/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    Category
 * @subpackage Store
 * @version    $Id$
 * @author shopware AG
 */

/* {namespace name="backend/category/main"} */

/**
 * Shopware Store - for the Category backend module.
 *
 * The template store loads and stores category template data
 */
//{block name="backend/category/store/template"}
Ext.define('Shopware.apps.Category.store.Template', {
    /**
     * Parent Object
     * @string
     */
    extend: 'Ext.data.Store',
    /**
     * Store to use
     * @string
     */
    alias: 'store.template',
    /**
     * USe remote filtering
     * @boolean
     */
    remoteFilter: true,
    /**
     * Defines if the store is loaded from the start or not
     * @boolean
     */
    autoLoad: false,
    /**
     * Default page size is 30 items
     * @integer
     */
    pageSize: 30,
    /**
     * Model to use for this store
     * @string
     */
    model: 'Shopware.apps.Category.model.Template',

    /**
     * Proxy config object.
     * @object
     */
    proxy: {
        type: 'ajax',
        /**
         * Configure the url mapping for the different
         * store operations based on
         * @object
         */
        api: {
            read: '{url controller=category action=getTemplateSettings}'
        },
        /**
         * Configure the data reader
         * @object
         */
        reader: {
            type: 'json',
            root: 'data'
        }
    }
});
//{/block}
