/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    Vote
 * @subpackage App
 * @version    $Id$
 * @author shopware AG
 */

//{block name="backend/vote/app"}
Ext.define('Shopware.apps.Vote', {
    extend: 'Enlight.app.SubApplication',

    name: 'Shopware.apps.Vote',

    loadPath: '{url action=load}',
    bulkLoad: true,

    controllers: [ 'Main' ],

    views: [
        'PointHelper',
        'list.Window',
        'list.Vote',
        'list.extensions.Info',
        'list.extensions.Filter',
        'list.Progress',
        'detail.Vote',
        'detail.Window'
    ],

    models: ['Vote', 'AcceptResponse'],
    stores: ['Vote'],

    launch: function() {
        return this.getController('Main').mainWindow;
    }
});
//{/block}
