
//{namespace name="backend/base/color_components"}

//{block name="backend/base/color_selection"}

Ext.define('Shopware.form.field.ColorSelection', {

    extend: 'Ext.container.Container',

    imageSrc: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAXMAAAFyCAIAAACIhK1gAAEM80lEQVR42ux9aZccN64sQFa3NlvyMnPf//919443edNaSeJ9IAEEQGZJnvF47T4+OtVZVS21rIwORASCTA8ff7OPQsREheieWEiY6ELM+lQhIiImqiRdP10/hEj0lY1IiArT+/GA6JB5UYgOoq4vfvj4+3zww1/BX/h/7YX4og/uSIi4AnbAK2V97wCdj/kYbxYOX1Pg9xgQ04gOoUL0doCR0PUBcR6Q5eHjj/8/8jEVJqnE9wuCcPj/Lcv/e9n9U5Db/z4SKCCyyPqbxa8oNKHLIOa9TOjpD/8vH5Dl4eP3HWouxHfEj4kHK4k4Yne67MBlz1YQCiRwDuQyt/4FyYpYC9xIfErgjULUhA6hzvSmPwDNA7I8fPwmH/fE91Qq0d0cczjhCMdbO2KK7MBlHXmEP8BO9v+C5MYV+KISr4gEPFt/7UJvia5CjejdA8w8IMvDx6/1cUf8mMod8R0xE3HEi7Nfx527QgnvxhzecIgz5rH5FyRnV5ThyIJte0ABrNlADJEQvRfqnd4IvX9QaB6Q5eHjl35U4nsqT6hciEtEkwQi7Lck846YrFDCew1lvnEdgvgEWYT2U5Z8CLHyHMTLWARPicCsJD40daFG9KbT207tAWUekOXh48b/iTsqj4gfU60ZTVg5yBx5FErknLasELPOK/k254As6Tb/0L+gRa916gGgJSfzkew0F7xy40ETetfpjdC1P5hND8jy8EFEM1dSHlN9RMWGHYAVE1Bu0RYhKTu9Nk0hHEHkhKpsWMVH6Szn5EXSl5YMOmcTkD87+MtNlBmM5r3Q60bvHiDmAVn+xoBSn1C5p6L2MA8cMaTYoonptfqyM7UlOL/JJwKGkp2jnWX8ETrLDeZC1PW37zazRYS7QVhMZBl8yrDGH+Cz8Jar0KtGb9sDxDwgy9/jr/ueyhOqjydDcT7CC4KcDUH0IUDhwFM43cL6gGMcTraWzsfqLFu3ic/DLOu883EQc0pY4mOxyAzRe6FXxwOLeUCWv+jHHZUnVJ9STdhhPCVe3zw+ubLxm5chKCssfCKnbqNtHzUN3Ri00u8n4YrRmS3KBIgB+fYD+KIpmAA0Qlehnw56/2BdPyDLX2Lq4QEodcIHcyYpQ4jlE9oyN3GWsUh2ki1vaYv4+s/KUFa2IvxvIcvGEroBY9GQ3kq2G8LCzkRwLLJEr6kt9sa+CDFN6J3QT1fqDxzmAVn+jB+PqHxKdxfiiCa8wMe4MpkLOYUJcKMvtosIH3zDDDrnL8J7VQV5xi/RWU6WBbYsJgNKnMq2EIPw4RRmkVdknYkMgCRQmLed3jd61R7+qT4gy5+EpHxCd/dULo4LCVlkYS5M4aKAsOKo8UtE3I2wsrVuItVYY/e3Ii1ZuN0ZUacx3IXICDuXkR2wyW5K2gLKBl/k9Moh9Pqgt53aw5T0gCx/zI9hHj+hS9mgyfZxHnwijvBWsr05DSGssP74Z16IyQ5QaKfXrpxF8r+aFUe27hTtMG+VbzlrK4HFLFf6idoSruwIS0KZTvSm0auDjgd8eUCWPxSmPKO7R1QTRhQighDtCUNJKDMBBRWWHVsRyigjcY3oA1oH753fDdZ8JLKkSO5GyDnhKXSSahEOTwUiY0gR1Rb7CgFQYHTqMBx1xZcujkHXTj9eH1TeB2T5vT8eU/2U7uvEEf4YkrIdiCg+LsuVOCLhfMQ7p9loS483L6Mbo0912gXx+aOR5fbuwOb3s3gLh5QKaeBl7xCdCLrOYhRrtoKug0iEm8RoBtwcjd40+vl4+Af+gCy/+cendP+I6oV4ByjzQTlFFjqjLRFlhMJYtKq5hNPTzvrpDNk03sgd9oOc2RsLPjQf7WafVUwZGCGFeNz80aBKAvKgG33xjAK+cGQlwG5wSnKIkXPZBdEEAUiCS/3qSm+OhyDMA7L8Jn9fj+nyjO4uVErGkY/kLIm2bPMsgaEw8VBqTbJVPsI7qnI6f1g0LqZvV6rSf/E0ZKPKiVMl65wGf6yN07zk6PKUJIFrSYKYeOUGrKyA0pPE2+mnK719wJcHZPnvfTyhy6d0X6Z0goDC4ONQCdoKgsjUYnfec6ItAlEX4j1b2Uq2CWI6hlyISInJOijRbtGnfySyIMil2WcDbxwlFZRvAfOyQxT9Zn9WAsFBwkJ0E0QoTEB7iNFPm9DPV3p1fbgJHpDlV/14RndP6VKpIDEBjGAiWbJwq56SSMrmAfmV7WS0mYZu0pat65w2kDvn4tut7btDFvtauhC56iz+RcstHXdPWHBLiCOIgEUtnO2hbQZX+NwqAtmlkWvGNit1IhK6dvr5oDcP+PKALP/5xyOqn9D9nWMKirXrHOSu0M05yPjLFlBChmXRbrFFoX9IxJVt79KyQ3TWlHKqs2QnqGyoCurMG5lnBygTPoqrLbYEQDsdNzGXG5GWoN0uaNJXUiPU0wsUa941+uk9vX+I2D0gy7/3Uam8oPt7qgwybYFMbfmAZLtBluIogGxFkNHoaNNLjLfgfapfsFOO0p0qLJR9W1oarztnS+jDnGV+lExVqJysIPIiryxYkyTeW34zTzaRXiY3CAtlNxoBpVO+iLJLB6A5Gr1895B/eUCWX4gpn9DdE7rDqQdnn3PtNnMWgkzKzYFoCCImxOTB50Pec7hbMZurP+9lqZhDVWX1cz9KZ3FVpcR/ULxBuA8zqKKGccnANliMRPQJ7vKOznzsTIT05ETHxfALYtCr9/Tq+lBq94AsHyXT3qlM+2GqgphSzi2hEmUXm4NS3BZjcgSMZlFbvFMuAUoCjhj/7yfSqiTHZtx0/HHIgpwlqz4IHGUjzWymIdrJt8uDvI5IES/Okv6iKDsA4oyzpJloxRq8KCREP7yj1w/iywOynH3cU31Bj+vECycpZUNVPkBbypJ8WwRd2Q1EOPWsEEPrQERZfJEl75/GC2MxZg/JEo0LrjPIo1lnScLtSl7sT9kju1kntElYEs6xFjtx9JvjdyKW9pPwLe15CkKM4ks/icx5WldicheUl3HlfaPX1wd8eUCWZfx5RvdP6c4wAtBk3v+Fyjrp1I2Uu4nA7QTdgCwE8q0NRAgfRbGgZDW3n7lCcH38Fnb3+f1OOc8iMYyb9nIWnaXAA4mGlk4xrJMObZcSy0c4RGW3QETLcDTuc3S8aE9knJsAmoxvtW+VXZRgFsJi4NKFXl/pp3cP/QwPyKLjz3N6pDwlWz96XYCqCMeY3LjbkZiUONqg41M2Ukt+McorySeivEDUKSToVhFXeLNdnKSW2+Tlw8hyRlX89ygLT1mtIt4Qls0DzunbJL5socTtoTTvcPSGEou5KbIkTXdgTSf6+R39/P4BWf7e488n9OieKgAKR8l2Q1sMZeDiXmoZd1wJBjMCTU8DES2MRjNowpv9w/1YRJBPiQqLAVM3PaUAN+Hc4pZmiz2y5JgNUJUwm/EeUAYHE1nIi6XmymZHUZYdxXFxLiIhspygjEstC3PZ+EQ7tWUlLAIP3jb68e3f2jn6+yLLU7r7lB4Xx5Ew/sCng6EEPYVC0NZe31lRpmRddpVdUMcdBvM6B83Eyprlj/yl02aNiKDQ2iamvlo/qNTGI97Nhz7VWZJwi1oJo3DL2QmagHJCYcLIU1QQObGHMr5IIC/9JJ67GY5kn8rt4hvSHUDHhRjxNB2CSyf66e3fl7z8HZHlQvUzenyhWjKUrCiDfrOxFdRNwqdlt3lYTzYPd7KLxDkI3R9TZLpuEnVYIErIkuyhziea7hiphNqaKaFo6d6ahvjWEBSgrsS+7x2yCIVXbv/EAXrSBkBM5a4LRF2Tu203HHXaxOTC+BPnoK7x3B5nIsOXdwf99O7vGKv72yHLE7p/vlCVkoegs5lIltQcbbeHyq44btw+JdKWc7UlmD7n3rNlYXwOinMDajGBg7DbzD0lSHhf1TZxwGIslCjJTnZx+ZZCoE6W0S6lXewFq1yU8ywcIKMvnnTnWwF/nHSI8kzUSL+sZBazmYOAsDjEdPrhHb1+/4Asf9GPQuULenrR0cYk2xVcokOErMSJCeILUY8STA7dpnXE5QHBlV7An4Wf9BtBN92SIOJa6r9HpOhbcXcdiygqMsmHxtPVgqRcQlIYEScvN6c/R3GBhqJY6+tCGvwXw0KZb8kouCUs0Wzuu+EoQUyXqO/KCXNJ05DorDSAqftOwI9v6NoekOWv9fGILs/pycWzKnn2Wb2hxXi262uc3zFl/GAuHs9P+83JG5Jlvxnno6ybKOgY1vRF1g2EACTUIOJS0B9QZ8GblMcPbN4hC9Gu7e5kOOocZZektqzec8nrBh3yMindL7wsDd0chWTNzqW9ITSYd7tFH5iD0hXzjIRapx/e0NvjAVn+It8hf0ZPHtElYcptcLE5yC6OH8lltyJUwhyUZp8P7jf3OBCtuThRhUVAjpFlgSjPQUOLSWYuw498CvygK+JwPJtQbnOWNNptPSOJaouczUQle0Cn6Vv9tBfiKKyE7FxClhupFgr9lSGka/hiMMEh2JKmoZH0TzMRDkpvrvTDm79+5uUvjiwXKi/o6T1VIq6OIKR2T9BWAGX2IgvY0iuO0DkxIUWlbVIuIcuQZtEzIhVr13Vne9Bj2FUW2uLzDqbmEluR7CJ9LLIIn9Z/m7aEfyDGmBwvMm05MZ63ATmUXbYGM0coiUHbMWQNbpYD/iidLK7zEID7yUwUrhvH0ZddD3r5+i/uSf+VkQXE2jQETYZyYw6ima91QNlJuUG+BfgIakv5kB+0TkCRm5j3bEoKwopAncIpxOD1OBz5j3YIsODL5MM6Swn9vWHkWRzyzeyzu47yrYCkcstv3tITPi+Xo2UI2gVb8EEWbrUUim7CShqUxoMm9OYd/fD2AVn+ZGItfUJPntJ9lGm3Q5A/jvIKIo4kKRdUWyqbXSGOtMWqoVKtXNAf4ov7gj6CIu7OcpaoaXTea7d7TTcijiwVLYgsIiW6ziCvpLQf0S7bV4Ks23cDnqzGs0oqZNpK8QmIYXtoPnViP/fVfj7ZIeqytPzTZg5K+m5AkDPaoldevaMf3+qJtA/I8gf/qNMDGr0qZQccicXMKO1Oecl+s+ZT0ig0vSEL3Ub7eU3NpYuy4yxmFSXvOWBNGh0iZHBEHElbiNGHDuSFfBpavSGREqahtBwUuMxqcSUE4Y3aMu3kCjgC9GS4QhgQ/DBhWZNyDFuINuCYb00nSRbKcNNXvxlQaQWUFV9ao+9e/wU9o78asjyiy3O3lgOgbDEFPpWdZyQ3UGaQjliqIJxTc8zUeLIbiSTF65224ELhZ3/wg+DeHPcXjx+9i4ibFm5Qu027Qm1HUmQ3DWVk6anXt8SYXNnouIJDE17XmH+w01lNHI7jz25BMVQlpAfiwRbMvHQ6T9+yTzqOF6rgbqSWCCuu5q6ERX9tRK3Ty1f0/nhAlj/qx1N6/Ck9qsRDoI1sxR8YoGxnIhuFFsRJWVuOo9CM9hNRmnpKvPUMLMomz0J0wl/AGOoxICfxBWkOwnGp7zRdx464ItTSs4gsW25CqtT2skm7SDSMVvm2775bV555kW91Juoovoh+5XGH34jkGjHhXfo2ERb2OWjwGoSYnuaj7QQEF0f0bgWa1+/p+9cPyPLH+zY+padPtbFpBZQIInwyIvmK0MlMRIAIrCvOsqRyhYOUK2tq7sRsxgeyqLYplTvZio0FUazNTjNHKOHsCjUOR7On5pOMLGERse6BRnS7AZ8NVAUV6WTulBzLQZ/I/WbMs6wKC/vhIQIDXjKk+27pOcfkDDW2EAPZXDnRWdZPgyfdqQ/Z5fVf5PiRvwKyFOIv6JM7EFYUKcoZbSkbS8gDLGeAskbjCuRWdMMw5OJgbkr12r1uJqPNHLSothIXiNyT3qq5oNG2XaRlvrhTKxuTaN6P4BllzmLIIvGER9drawSaiDsu0+5mJbwutLOHAFDmvIPZXEzHpR7cZde5L1XbrrBwoDA48uDFU3soPegBaALWCF0bvfz5r2BI/+mR5ULlM/rkbjYhcNmwlYEIJQkrMBNtwMXsnl0ql6KUK0sqF90igZAL7ZpZggHEizSxROZCvIVCEnfjB0WgSfoDDhwtCSuILD0k6ySfDltO5FuOnU+8CcVR3c1EpuMW5yPBHio5F+dUpUQKw0vAv4D9zLm2si+w0sxpZoAMWh7TZmno1hxE1FeI6RNcvntFR3tAlt9Tr737jJ6WqaoYQ0EQKcojigFKXWaiD0m540dvWbK5AvHc1MOSHySzuZywlUVtIIjMiZb1I8RkAyixlTj+CG+CZsmHbhRUmA9wFonT0ERQVFXKXr7dUpUJGQWOB6G4HKSGNOGItIxC3XTfohLs4h9hrVyHo+PT+OM20DoHgVjrwdyzAAttXrByFtE9gB/f0uu3D8jye3w8pvvP6BlSkkJsWdskskAGl5m47iNztETmcgC3hKwKSrmbdH9qliv7aBzjgFN2cxC7HNtijGXDVm4qLD1xGaAnPRYSGIXplLcBRFKMpcyZaJjEU8cFFidxpcgcn+nJQ11LMJ7xmwGxFq+jD50Jy0muv8crqPK6o5zmIAHmsiUpHLweogVfEE26kxQzj3rXF3RHme9f0Zv3D8jy2368oKdP6NGCIIG2AKCUyEroI6Tc1Sdaw7jjli62f1hypCVY0XCE0BBZ0HXuOBBx3ubD6zYBJbYSno02UFMXqVMwjxA1OgXvBceCk2koWUI1h1wmCiDulDgNGWEpYcYZI9IpoJS9SZQfQHCuxW2jwW6ycKsPulKSqV3v+ll66qmEpSFZFhGD1LI+tXs8P+3081v68c0DsvxWH5/Sk2ce2y83FJaIKUFkqb5qSHXxnoeMEpnLVItRZIEAy3SXt5iiE9ApW4ERqUeHyDO1OAEsW84mULSdA50UlrAKIC5xYjrOtoLPp6GIHdjHaSOSlI28Yg9sxsvMZYwwVU9KLNEeqlE6wV3EmM3dMpdO+7zcRq9Nm4c86UYClK3fvB2IeqzLNfjw631e790TMT+/pZ9ePyDLf//jC/r0ni42/ihYTEvoBGgovmav4KapJ8LHWV4udFOWWH+LHnNxkmLVlomtEMcgXNksOq/plWZfx8alRcTt1h1XfPBJkRbDHZdy2ZuPznWWEjL+AkTGdVwjYJVYwFFeiIwPQWuwRY8HMLs6jEJL5B9lJOFoG3HAF19TNH13/E1JzPWnxC3tvGfQXNBaNgVXlrBcJ8eRzF/6fPb1O/rh1Z/MjeY/15/1BT17rEOQUhIUTUxMSSCCIstGwY09T1JPNoYWSwjb/PGBAQfG5KQEkhLWaHY/wtGZJcjIdQ7xFom0paf5KK7vNQoXUbu1T1s8sQcpzKKzRD9M4GIIs5RNNZ4wMJe0LhSJDBGouQWCtimGy+AWIXZQTuhmwoIm0Zlwi+DCSzpOqMW1ox6pSmIuE2J6Ji9NmctUfE1z6fTuoO9++jNtGP1pkKVQ+Yw+gZqVlbNMsNjSFp7mzrSKqqMP3ZiJ2NcOkbCYJdSrrgvVrNqaXtthg3EqI9VbBDZ67U7HlajaGgHBBaJe3B7yOxEnHfwRvmi3ZPSkhIZKs4pkMw1xqAunhaTQJZbIlfn9+xgl81MBMDIiE76NtKZYInCU/YhkD3ztsOQwi/GUvjjTQaxd6rVXCnOa6CfgJrRTWEb7HCgsnQJt6ULv3tN3P/9pwIX/JH9K/oI+uac74ykossDUM/1mDPhjam4n3G4WneNKtJ1hJtFFomU4orhM1E8iLYmtcGIlKdhCPiIZ/WkUEKdpEhezuYG8iMs0Hc9ZL0BMYqTFZJdTZEFf3fJy2WyOFwNJKTHmb+tCZY8gPiUlF0k2Sf+ecnQcvqs1fdvPmAsFWEF3OblFPRrSa7QfmYuFbu16M8PI0KfH+UijLl//8OcAF/6TsJVnj+gOyEggLAtJCdHbnSUU2MrJGlHHpH/ZVSjovROkXHjQtTq3lyVuW091XFRbEotJ3rPdcT0e0ROeBdVWFhE3LQcdMAcFInMDWQRR1szm4stRaBsJR3yBuG1X8EbNJedZOOZZ4Jghi8nILvLfkdrELcS+bBIF4ZaXc4XILSSMwxkxMVyQyFy2edws347HEVPGdVNe3l3p2z/DWMR/fLbyD3pxoWJxOEislCS4FA+2UBqRbtKWnGqJ3vP4eZwTuiWmbEtQcLtqMdkSKrlKri/iy0ZbQf94nYAQYpTg4OEZLQoug8K0GKIzmXa96VIFlOssUv1oSJdsE3MZo00NirTLt5HOyEJkgt8M2w3ESwAXgGOOheuyYtGJpkCTU+yU6wwdt7wkbpXUhJGHNr6PYEplQZMMN1v5FmAFaUvvdG30zY/U+wOy/Aew8jl98kj3DD8ELme0pZyMP8UUE0QZU0/wLTd8IvadZkOZxF9yErfMagVeRBYBo7bH7Fxf8iw32Erfibid84ZhR/SB2EdHQfeUs9SpTrlowkGLTnncoOYqsiT5ViqYRKq5hE9psYEMd2ogMqhLz9fXaCfzEudPwi0twMHnc5A2KmSeQnn/UChAhkTygotFCVwwR/f2/R9d0OU/Nlt5fqFLRJAC7MND/Yv+sl0dSsF/xuB/7NN2nyhpK+uRIIWYqC1SLuq1BZoTaB18drTFRh5KJgkDeVG9llF5odkfsGorNvJwElxAZwk343j9qYJbNQLHeYdogI6HWTDvX8JMFORbjkNQWhcqS0nEOgrFTcUumyvGdNrSKecPlLCkaoWzDG6DI1m33jPCh5OX5DdTiLG4jtsWxOnUhd5e6eVPf1zmwn9YWPmMPnk82UqJYkopOwW3BNW27ABFluvh8UCBba4/xlsoAk0yngkRpMQgO3taV7Y5MpA4O0AMxnA7rAgN7pPoiUm8aVGogeDSse1E/KmOrhATyRRfbD1OiMVWnOf4szpENcq3vMi3NfK0qiYRZ2RJ82EaedJfh2A3BLRA9WgedVmiLieabqfcJte0C8qNIax62im4m8c9Lij2nbILrpBBUoOZaIDLdz/+QZnLHxRZvqDnJtkiuMQBx4IqWcHlaSGXHYispVACb5Ql1WJLzya4GFshlXLDlpA+aGV2QfWaIy0Y6eCk10J2rq+yLuRZeqpWGLxjl8RtHFL8HeEGXKFOYUQY/tEBX3Aii2AtywWicTHbIpfIXCDhIuq6SURWZy7Rjc4BuWgSCe/zuJ1yfM6yOrgWNWec8fXVcu7a7N+hWqHFK1mUXRYUT6GEVILp6jfTRsFtkjeJJqkB8vLmHb386Y8YovsjIssL+uQJPSpU6oaqnBGWEoGjlLzffIOtlKGtJAUXXpk12jg6dfCnU5dCgJISw6jsaosnVmq4DdHlyeTFpFkYC6yzMgf24UbrMSYXkIjCiNToBmcxX/mi/VfI1soSw43SrNRQrifsfrMTFsQXTNyCRZ0mo7b0dK7Xw7oQ7iWuUw/HbUPOc1CnzbmIgblsq556GJradnsIUnNb/mIo04Zb9MMDsnzo41N6+oyeFDeDeGUuC7iQvZ5JClVkNOwJurBGtBNczrafKU5MxHu4WQ91djnW0v012szA8ZPIwuytCIP+2EDUyJ8VzfUfsDAsuoXYeBO9DTwlLjq3BV8WnWVBlpTH9VIZXB0qQWfy0ArGAavrSQRURQQ4DgJKiRtDKdWCMVzbS+QYhANzuu+WhsK2oeKFJ/oxNUe7CD8pGVkCuGPwaRL2ngXllb5ziPpCZDp1oZ9f04+vHpDlF8AKYkoB6pEUXASRwlMusanHvkgo6Fe2InUJvOAotBQpeBJX1VnG7ZkljOvbzHEUwi1n1Hd7jMyFgUhDcY2DXttg77nrCUSHukVZr1WPGXeIfOcO/KAGfjMcPMSu4ArouLQylxrxBTUXuNgBetAzyviy5OV62eBLX+rmeo21CQthceFWd4WMwrjKi1KubAJysgxEuPcc8ixL4VM3iEkxuQVcwtyE4NLp9Tv6/qcHZNl9PKb7z+hTXQUqO6qSAeWkPGGrs8x0HCRfQvB/GYW6bgN0zuZRsJkh/JI3aQwpSvjhPbq4RSXetutPQL1WwIRuUAFlqkoSHzrMSp3CxSHNHAWk3KitNIj5N87QM5FFojdEixk0mQu6PxXScZG5zM4EYCVmMHdYpxaKv/KmBSr15XXehOV6WXaFxoNyMvXQRsrFOcgRBHBnIlGPuX5AmVArR0si7mwCWtiKI47Qyx/pzbsHZIkfT+nxp/Ss+lBDleqWuSx+c4nuT43i7tqr4NFbqG4RRRwpy0oRB5k2zET63hkZg+QLbXcRYQ+A1uW7utjMRltwPiKnLZhi9wGngNHDwRgalnMDFoMiLhMdFNN0OB+tnMUU3I6pueSHFTiA1VAmCSsc14WgmUEoCL0ZWWBccjSRgDv7vecFaHqshupY+6RcxoTu1FaZvWeM7S91Cl7ydFNnyWxFouyygMsgPi9/pLfvHpBFPy5Uv6QXdYJCGoUK7jTfZC4mjlQYf+rqCuHaYQ3DEbIVQxlUYQhWoptyJVn2FUVlEYqRDqQtCWLO0nEmRyB5IfgJPTHFShIAUPIEBI9RheggYjpbYZ+Jdshi31sNwOHMpW6ElUlPKgxTSb6t4H4V2FFcuUkSene0rXPICIYVZxNcIMnS04gUJ6PtHGTjT4uHtI6grc04oZ6Slp6ENdpPQbttYAnZ4mKCFRuLvnr5h+jQ5T8CrHxGz+/oMswgdksoURXWKWmflOMlOLesPhNay3F7CB9vV4qCXltAqd1NSWl1iFSpZcCUgDU8cx6tBFUl0BbVU3r0Wzumb6Pa4k9RSO4POpOMkQE6qNeOG/AWsgjnmcjxpQb+EtyiC4nSHNtO9Gko+UHFV6KzWBv3qdD3mqNN9Z0FPIGocyQ4IOX25BDBZJQHojOs2e0fpjBu2khM+JIHohYF3b7/tWH2/+Xvn6Dj3/u35y/ohS0xI6DUPbgQUBuKORfabipG3LEcivvQaT5awKUDNymxoqUXUFtiZ+VI5RIarCC7MN4UZeMoj4IoiZSklyC+jMcH+ESdQiT3WKNxnCVbc3+awpBrLuT5l0VnAc6So3EX3RXiHb7YNFScjwyCIxDy8dWhi8ZYMEQHU1JXBPGBiLzqRbCMk6PBnAgLbcL+Pf1dYFAlrilmWGHHlHmk/K5LIS00+6ykzMXZSofGFrSKdkBzNPrq29855PI7I8sL+uQpPQHVFuediSDVXaGVuXAqSdiBCy2vMcioMOMULKkEpzlZzmG3yGYik1dgbhJQdsUittFvDpgCVixFntI4kxeCupYO64gNKExPUAKDAubf0CpqOgqsN1c/m4YcPiO+mP4iGGkpWX/BCig0iSTquyERB8hin5oVPbHAXLFY1j/b/JNwSwugAscJpdkRTcZXmFwDL64d2ov9fPrfmrhdjOcb09B48OrN72wV8e8LK0/oSaQnJUJDXQWXOjXXMt4I1k+O9kfV1pNyJtyaKxRbF7Jwu6AMxWoFiT5R8pstjBsSp2X+uy3FMyxHFHoRU0xeQT3F7rWmmGI7AcZTOuc4HGb2O+TIbCbqoOl+CFnKMhPZltAlCCtM1C/EAoTFZkIG5oJZOFgX2kxJMd6yCbOUfLRzEGjL0pyQPKA0B+EaNFKShDU9jkuQjmu001yS47M1g9AnwgcIJRFWmlDv9MPP9Or13w9Z7unuC/oMQSFyljwHfcghOkvQbY8fopRhwaWhHVvZrBElVaVAecJ4UEKYxX8qFz9DPtCW4qtAx3iWgzd0lJCOSxm55BOZuNswUwtu9AFZlcb+o7rBLWZz0A5ZTJo1toLrzgyTESRfRJN1KOJOFkNhPuoQkMncBGsrl5h/x74FGAXJgBaUF5uDPClo+f0CpwsZ3MaNobVkO5OUxSHalGmvOm40hlwGXmDFDaMotczpSei77+nd+78TstzR5TN6cTd95QAoNcBHmINuBuf4HGtShqUoi7eLNgr1ZQmAAEp6fBmuEfUFbvouLydR0BQ9H9qDcAWCuRD1SgORrQv5xbiUF5RdmfHcgzOa4A9yZyhxFGoxktsFkIWKbyTKymI4zEF23T0g5TIJRDzAoijDkqGkR/7SOeu7HTtxsZ/FnGZenGZjJZaUK7lBzkGEI6x0sKWjB9QAifK6cw+LzmuMBTP+YR1xoSoNMMWuH42+fkmt/T2QhYm/pM/vtH+/TpiwmWhSknpCXs5E3HIq4q4KLvYnWIJunrhao6SypTCL0xzW8ZLTXHNVJUq5gphSTvZ70QaiMAqhcJvWEZtekZ2Ia2SkR/u5gyWUwWVylgLp/gprQSVm5ABrgs4SXaTVKkKLHkehXmJkjufIg20R83tYPwWe4sKtFkS51MLew9KjVdQlG0M2EHnqH3P9DEYy5ehKCNrSbvZZV4eSmELATWjBFBN3O12P38cq+h2Q5Tl98oyegpIyqEpQbTHAUsP48++BS6ikhAMVLaorMZLLhVhILrDHvOwW0briDDMRoXOEIV28fQYE1LA90zXwQpyBJg9EsENzFGKBF4DN3EHERYgx0OlpIIgi7oeRJbAVDLMstEWKQ4/Lt4AyKOXKJR4SUiDCf/ETQsa7vEGuwO4yxflI6xQwehuC/DSdJtkWU+6uHEJsUCJL0BbpTGrG3SopJ7CSMyzoCskpptinP7+mH376qyPLp/TJ2AxaVBVUWzAdh8Kth+WYpAZ9l2+DCyBLORFupcT1RYOPeLBZh/VoS9YFE9ra+dfWW/0KAvKKBzLqJs5/WJkLriCyS7aDwjR8AQUuk4gMhuJc/VVXxChMo4w7PSDLQIe6i8yNx1HcFTChQ4VChaScXVTE8aa4SOfGU2jUW4al1bDW7J3bJQq3JQRYHFYKzDjRGDITHiejTrmav6H4ImAeU0AQuSHfrunbHj7dqramrfiV5q///off+pTo3xRZLlS/pM+ryyspFJfAJVOVARCX/VNpK5p2tf6h+Qmi/ZQSK0phStwkahV0FrWWsHpOkj0Epya2mOvH2ScJK8TTMG1L9Na81FagsFIxpUeRxX7AH5DBHeGXg8J1XBcSogPYiqGMqRZdAFk28m2ddGOuQScz6OLr0T4cJUAxHxpDK+Nb1YIo4dwp1wGenbBEOtMNffQvLgfkyqKz4KqhXRm5Ejh1yOaghocNmSvEoTwhV+H2k2xLCvXj1DNe0OJMFIem1gLi9E5fffubZnN/O2QpVD6nz+7pbiUsMAp5aGWHIOP+n2+v2Tw6BReOmovpLNWrpCye2xFcQOJNJf450Q9QEmai4qOQRCm3A53x/cMSV5lVTHBuAvXSwuG2ajgcGZ0Z+4dDi2Q3gEjoWkDihYTukVjMnrMApkzeMaIrF7CfLwFxknw7cecO/OYaEAf1FDeh9WV9l3AJFwd/kYWwQJLFa+I4yyubAC7gS18C/hMsgMvMngSOsbeUarnNVsaKwDoQJZ1FMohMn6iH+ej9e/rm5W9XQPfbIcvn9OIxPUI0SaptjcPRmH3qHl8kRl247sCFA3OhxYpOJ4fQUtTSK9W4QCTLCSHZe9bsXNo/zDORjTlWOgnUvpeg4PaYu+1RzWWzfsB7tsWfSWdidKVxMJtFexXGDvSI5B6oudxGllk5o78O88+KLGWdhoynFEjKGZpUja6wgsgS9ncuo0VznYIWI4tDZAru+MtKq0M9FXZqIUvqasm1CQTqCbuXbGiSgi19MZvlhK002qwyr80JK6Zk8aUHK/rNW/ru+78WsjyiR5/TCx126hmalLB26LymejfCfkoquU2u7sYiinkWG21qtI0wdGtdc7KoKm76bMP+qfapBC2SCywx1xyQsx/JtnDU0fop7hD58mFKxy2w0lHTNfdnibSIxnMPiLccZ8gyWclYdL4AmlyC8iKovJQFXNIExMEVMj8ojEKGILgfVEOwJfXI9RoOSEyrQ+GvJs5BrSwPaJdnMUmFlmLtdJQq7cxminwkaSgUA/6qp0wJxkL99mmSXQBivnv5Gy1D/xbIckd3n9ELtZlXJSVfYaKLVygE6KkLW1kApegSc1n02pW5+EnP+kpbWUzri6bCELvO0jUEjN6zz0RC7eLpWy+UK85TMF9rO83DG/LyBBBWAo4sFOaI3rPJLkeUbzuIuONTjPNfNaRrVw7QYlRnGdBwpweDMAT8S/CA3AaqWVjBcck4yMBsF1xitsVzdBLUqQ7LEbL2V26TLEzHWMeKPlHQWaDwqce9IYzhdsqN/PNiDyVyeyjB6315vDIUcaSQdXtohykIOsdBX3/3WyRcfgtk+YI+e0T347aP40+YfS4hIMc1vIB2vMbAohZnFhWIiYGLERMGvZaXJK6BCxpDp3mWssGUqdEOTElbQiXvJZpu0nF1KHnMsO6MrlBOr5T5lnDFBhzEHXCgG6ZsVVs5IO9+ILIEzqJaLHNgK1RJasjLib4gyLr2WI2e8dhNZSiL2mi3JWNqrzDyAKa6Yaa0BY3nvgRbVp0lPAAlxdjK4BFGcxxrbsAKPHZ3eWUrADFHhyRuxJfEXNo6H8VPrwd99c2fH1me0JMX9Bwk2wq7hQXhY0ETLp5n2bQr1A1b4bi7aM50eGzgslbMobILKCPLoCQ77ZZL6G3pcSZyH1YV3MIQewNu4kGw2NJCQGHwzpJFxJU4/syhJlZAuQ3EOcvfyf2jW8hCdzHgbzYzMhSTde/cWrfrwWNWbVyiSYTii/Aiu6is66GVJZjrcIPGM85BEir2rBM3P1jM5uAKUW6Ny+UJC1tpa7ZlNwGhtWxuUVB2V5QZn8ZnDV9e/kivX/+ZkeWe7r6gz4GkVFNtT8gLpacQXLZOUM2Agj24ga3swCVsPAN8iL59OM0E6BPaWCDhkvoWKPEX3B6qPvWQbglhrt9Wlo8LFayPW6ahdf+wxx1Fu95iQG7MAVeVbL2HRdO3B2i61w2yDPi4OKZgvEWKCrqXaDmjsFJBvjVwMSLDC76sO4pK1RCJRWcfXLsS6BMXJWMc04Q5s8+B4OAVO9zDlww516/4AhEUViYoyY8XpzmNP4YjLX66wRGh1qm1BYMUX1qjb76j6/VPiyxf0OeP6BETX0LWdsUUXvCl1pyX2+CLjT81dN+mxwLbQAlcsGS7wA4RwalmvYaCBXyq6Z8w9MuZT6TQgNswHnsRanX24JrQ6/S/nPpBYzK4FvCVqxIZ9ZsPiM+16A1hTO6gwGXG9fH6Bnm5K+osVERMvr6L2soq36pwOx4kwcUGpY7B/zsnKWMsmq77JUbmSrDlXeItoVOvQ3VuyNeyA5Pn+rf4EtcRnaRwbITqbh55vXaPFIZiTdwKKxT7VrZLzEtArp2bQe1kLGpC1/f/3Znov4gsz+jpp/RppTJIgQJHTZZzzTbQ+umq4yYHOqwv1k0YlyAOY/qL97awg4sNPpb9Nz/IKEwh5TK2nZgwRdedBXK3uKnYobbSAv6m4+JZiCNTamEWy8613Sg0XtOtV6S4vHKNfjPOPg0mo6ZX0G/eTEOmsBCKtcMqvtNgiyELK0MBLzkNR5J86BpV20hVenVtyZIvHZO4+r+knwdwbQ4KTeIIK7pPNBegKdbxUwz1kxtAm8IEikEVClDinbj9pEZbssszvj6SEcMOYy6tb/L+iC/f//BfrFn4byFLpfpP+vK2art7TPAW79muub0lhHGXpedtwkUi01krLHt1qEIRt5RYwqJQQkhAUktLwpTiWX4//QOcIFFNt6l2W4C2dAi5IIVpKXTL3pBgE5OpLUZPPPVv9GTkPDgIK7isiNNQoxqQJSwNjbHoAlBiuHNxGWUm6y5uPOOIJByL5hBoinpAWK1Q9TQTjlk42Ff0ZKFEFQaLFEo8pQz86Q4x3N6VDXUIzolnWFpEk7WcJTCUHYi4mCK70IpAEE5Oc3EhMteyYdTafNm339H7938qZPmcPntMjwvVugi3Q3CJBKRGhrLBGm3JJXgvRVJz68hn3Z9mGHZq2Wm3qYW75IoWUd3XkrhhF3ElMkRHzaeyMoRLh7t8rbOTRZZ0XCt+UJmHWXT8wStTFonOUYcFogb40gj9Zh7AcRBjNK4RCfF1Ygogy1RtL+IxfyKpwnNNUVxSiVqvAOikONwgh75wqLKLdVYaVRn/qzqFqK4d3jy2MzHegifOdvahMdMWBBo+Cd2i2cyxSXt1gkQBSInJkQ4DOdlydl2mZ51lU9m/jd4uYZZEbUbHwrv39O23fx5keUbPdA7K9KRCB6U+W2tO+p/WtYybPIEL7AdwnHrqSS2uvSB3RDG1ShUoCc5HgoXb8ZCQXpWY1FDob+0CuN9shxT3i8dbhIP7c1QqMcayjbRsJFu9OKNuxeUVF3GJSejgASKsW0I8f/QSH7AxJEJXexdRp9K9P6FCm1wRPSdEH1SZnzJRFfShp8d8gf6ni3KTAlwGOQuazQVWE+0Y2upLzDYcNQzp4ljEsFvIMYZLoREK7aFUnrA5CJHy7INYM3nNzUWhTnGQOUncBil37WcxWGk72aVpvKVR7/Td9/TmzZ8BWQqVf9A/qhITPDao3hyOMC+3w5fcWZnycnUTadnGW7bgEvpxByRREF8oJugEjhBhC8WVsNBMULUtkKm1KF2o1y7gAUV1EiEjZXAtGicQcplZFUbHh7uDCHclJkR8JRJiFSL5cHmFzV298jINmcJClYhFLsRCdCFgNKIHL8n4dACNVGEiupM57+A0VAFQLBFnRCYFW4bTzIuOW3xDOsxBSFtKnIN4s47Y47mIRlLmGe/kJGUYQI0WewiXhqyxpUN1SwqtEJAOCguHWbi9Mf4sCi5aQklqmbrMQV9/8+svK/76yPKcnj+jZ5GnFMubVBBxVSKpwEFON4nWUQiTL1DmcgYuicVswcWt6AgurAZIUXpSsDPhMoejjsMRUpICKf7iC80FuIxdnDqLvv7QNlwpuwALmK1W0TLCpQMvRHGkCw+S0h1fEEqYFFAMSsaIJLZJlKchGHy0WU70uuheolCdcDMxpcq8yDLfyzJRA/6+gnYbFdwe87gN8rjmBHU4xix07ZEfkmJqE64L9aLxOVqARrxFYZCUccCtRMnWYQUnI45ZuKWGstHeEmq3u+Nw5FlU3t4y7hwd0i7Nn3r1ir7/4Y+NLE/p6XN6jmhStd5pMYkKWssngFIjgqQWhaTjCvCjvQNN1C9wtlk9BRfSvJzNR37CmfEU86HZC1kEBZe0QFSmRNDgwDNW96cjbSnhCMBZhpDSt6bXAtZ0HsDBjYiED2aa6MATSoTHvDMISxtERqgxu38qjMZz1+FoHKLYPClnODI+ZYCYKv6rcxbSbhfHFKnC5KQmLQ25pht1XEk6C/yVddoRFh2Ikj0UOm7JTbWc5Qf+MtCkg7aC3dp97XlKF2UpdiI6eryeVBVFnKOFYxJToh+XhppoOYvJt+KjUFtN6EbffPsrS7m/MrJ8SV/e030kJiu+lJXRpABubFHIaZcaShXwjbw4RHwz3kK4cLhEWsx1Fo20tAtV6GohAxfQd8VekLDGOp90VuqcO+rRZmb2wWcoL4gmk87QTLs15gEfRNQmjnBXPYXmaGP4QgA61Bx9bFFo1XHpcJ0lTUNFmYshTlEKU4hYAHeESOhCROK4U8T5SxUSkSqk5HBrOfu4hO0tmta1vWd3ggpYaBJpi56xNOiMdM/yo/4icG58EFNiIUtwf+RmRm7c6pT1WtFhJ7RnD+CQzbyTVN75uO3todV7bmobXQ/617/+qMjyhJ68mIeoOmTULNPWGoSVrStUQT05G39sa/GGjuvYUUO/nIV0iYNJRCfgUmjKKBaK4+IbzGYezaa4Szjv2YKpXW2jtIUnijtY9eSzD3jPIXo7KT+3iQJMwo15UBUmHugwpyGZ0NNgGpKJQcEYIgeUOSj1zTQEmCKFeLKSkcqVadebqsIq4g7aQjI/dUwB8nIRInFqU2XE+dNGolxCG0vniDs28kSGMgKFnaOaG7PJLtay52sz0ED01kttPx5WwBJKDCW3seyCcAliQnpFZu42AIeE+cgnJkWfSYUavfz+14z8868o3P6T/hlVW8OOG/iSE3SRoTBTuUFetkcpVpBdYvCfbO8xggtm51x/sSRLCbyGYR2xL9HbuWdYqBQ4nrm6pOJaZJRyO5whPxcLa7SZi4ZllaRMKCE+aLASFvtVaOBLUG3VD7LXNDZuwtqXxhCN477sDTXFhWg8z1ZKmancAvaQMxqZQDOkFlYK46OTTLgZF2nCjVyEIKfbDVmqN2/3kkuhOsEEJPrGExyZr1zNZouuFA2nMXRoC0RdPgZWMMCy1Ca0nrMtDUJxH0VVekiv2HzU2s4wMqBROnNc6etvfrU16F8NWT6l559M4bYC9cDBZ8WXohIGxv+r3uoV3BzcYxyi77q1iHiB5rQpssZHag0tLQYuRTUUzMINelINZdjhRvRK2iEiXVDEw0Asy9sLJFlgYyj5qn1nD42bX6ggjgzCcvCYVlhVFTZVxXjKABqda7irPUSAI5PI6Gln49PmGVxXcAWmIZRyxblMUb+5CKPCUoVEp6RhG/GkKlKG8qLXB4Up49txL6mndH+M+Quc9tbhYLOGZ9CSVq6UyEooHP3RE9BIaI3LDbhLl8IRe+S2Z32szSy3mUtbgrZZc+mThqzaLYZZpAcwap3evKHvvvsjIUul+g/6J44/CV9iniVILVFbWav8t7tFideIYU3cdUa5V0pmMW4S6Rnn42uKEhaBLIyBSy9UE7iwD0dWFtU1F3dgipdnvrZpmXY4fVSJfIm0RSvjmIe/I9w5k5Q2b1FuNAQUpCorvpiqEoiMzkRT4lWSEnUWKZ0LhFlUUpGLdrVYjGVwFsUaXWUUH4sKWNHGVmxKGrTlIiwiRVgnpl7EDjfA3YdAXjD2Qxu1JSw3F/WPIZLsY9HSKdeTZBsPLTswbksxwBLPBpndCCnF3zfFcWnk2QT2EXRano+S3+wUJo5F46mvvqLj+MMgy5f0j3u6Q9W2BlhZIy1pXDLSMYTbmkyiuqlZCOQF9JT1KEWuwSTiZUSaplIM+KPmwkpYqmKEvcaKFIjBKoJ9RbLChOg6H6racJRy8Qew3iAcmIhylq7aiqi20gE+SOjg4qqKuMqLJpHlXHAm6pBnQR2XiLpcOodpiHD7eVISnIAuwuZAm0M0jxYZz0qaj6QKI2EhodoTuxESK4tyXaqEg6x7cbaC8q3vQ1tpC4q1KNOyJmh5gRU8E96i/dBZeXu/uaX9Zku+Se5J6Cf7ypt6JwSgFmIvexG3ORIZ3Lx58+ukcn8FZLmn+8/pizodZVNVJl4s5AUzuPuQC4ov1Y+Ix+GoRECpSbutuajFKnVpp+MaJdmCiwC7SV25VjdnRQqtUmWfkq72pSDDghAjOBORbi1X3Fcug6qwcOPCQlcuNG0gpyqduKvsYjA0vGcFFLKLTlh8CJp67TYs10HH7TPCr/tBACWWWyEusnrPU2RJfnMBhYVwLHLyMuYjKZ2ZpHb2F3RbcW4X32gIqRbIxWGqpZdwHCTOQWkssl4sV3PjWrMhDuope5GFFBeWhqftHlCuYhF9u2x2lwNAQHe/QUYYiNqOwrT51Lff0rt3fwBk+YK+eESPCpARuNsDvuyoSo3bQ7WetEDVUM2dNhW3RS2M+i6aRJyXhsJhzyXk+lfmQmsFVKEy8vgm60KOrpl8CzORm8rLT1yXWlxMKaRjjrKSYmYQe27FUUZj+wNKphVNylAUVlhIGpVOiaQwQfdtysspsjDRncbhimZYMMxSyKGkiqu5AykKmVgbZd353zIf9YA4zt2EuM9GKAywlNCigNOQ7zTXuNOsrMR3iMpygBkF7TbMOBzXmtflQ4oZ3HWJOU5DjiOqywQmciO8L7sxJ2KKRWNmXq4FFvPuLX3zze+NLMNpLhkmBn+5JG5ymVfO8IWj1juEEj+klYM0syUvA3cEfgupm76F0UlUluit1HwR9ZR04BlW/LO2sdQCm4eq2nRYKeq6G9ztaCGGdP/sVeBGhRBEpmJS0BLqQE9oRmztlkP9hXBK6uAKiVIYPQVxPhiybo/F/Y2YSNwbEnXXXUmx3IqPRZq+zRAjM/7vo5BsyIupLa6z9CTr2qzkjViYwQW1JRWRD+gZeCkJVvCMSDyYVXbLQdCq3dbT4CXkazEsdxUiWRIuSUZZlhI9L4e7y2farQRKsldbmmOK4dFPP9JPP/2uyPIl/eOO7sdtfwkwUWtIyrk0u7CVtAFAODcBeamxmaXWWLOAtXI1plogC0NwumuvIQKTilpWcHGUYUcZKqHHf6IJgosSlgExM7avEIM+ETHB1DPCKaVNPlLEIaMgoIB6YmE5VsLizEWmtoJircdbbC/RHhxuFUWdhS4dQnE03ZwCJAWzthXyciX6zey5lQEc/j1WHYL8YndlV60xKcKDQ7FI6UwiRXwDoMRzZ0s4pQlnIh981AMaRzT1eJ5bR7P5BqxICPijXuu9KusRzrJrjaNIQHb2kI82kpXaREz2mNKylDuuXK/01b9+P2R5Sk8/pecGJQMOkHfUnMSdaHLJ4HK6ARDXizCGu0nQ1XxaCC4QcfXNaY57zLZtlEK6BFILxdVEQxk/8aPC9pC6ziPRX4eAErsZSRHnsLr/yfOLujwrbSlGWAAyyuAmIx03qIeAYWQ4YrtCzR+QTHtoyrdjd7HP7v75FOblwHWuUbv1bIuORYOVWNbWA/5GZ8ZkZFMPTTSZrKQHnWXuAfRlINK/sUln+px66skcFFeHQoYFT4wncJERfbr3J/jRQjHJ0nAaotDwtIosTZaTVbdUBcmIxKDtVqmN41JiLi0ylIkp9t5GvdP3L/+j4Nx/hCz/pH9WugzVNiJIwYuj/lbnGoebRXyhOEBRXUzoRUOpEI3bJFlKNKFrlmNCPwuR3C2duCtzYZ+PCCIwZD24KrU0yOYS01GpYjlLgUXE+VNXSYpw5wEiBiUhwII6CyXLWejggj7RfFZ4goUTGStG4GNCD5m+i0PQaCCZB2xQ7YosEJnzzSDwmNOvYzOoEDMQlopqSxBunctw0FmMnjDJEHSlNKaBSn0SmYvIciqtn1XG7j3jxvMsSWDQTdJAtBVxiQ7xZtwO+IKTESommyQLwgrFJaBYTBlStjAcZT9o2Q9yKbfFF7T863hwHPTVv/79MxX5P1FYntNnFk65KJTAHIT4kqwis6UDvujdnujJBQRarkGXweoWqmGPkeF6MKFBjimAGhVXhOoeXEaYJVEY68o1cOmxC8q7KW3pufi5QjRJx2AoG6mywxRgoTie0my0n21dKACK7w3JIuL24AGtDxRfhNpM4tUeN4bicvOQaUP6Nu4lDpQBG2gOUxwhBocgtotds/8wHxVY6a7dyY6RF6y8rVA8Q7E4zvL+4iJLo5M2OQq52y5L7RMvS8yxmPKAozxCYP8EblZ11p9VYmI5/bP9oCNpLo1ap+OIUxX8+vIlvXn92yILE39J/7jMQ5qrZmdX7MhqS8zR2cTE2KVwYwPAMvt2BeJwfD4ooWSLtbgCL7CcriydTxhmCXnc4oVyY1nRsMZPPqyQW1EJpg3BpTBPJaUYTMhc+Zup00FerjxfyYA1XYGjzAGH5ysp5V+oC3eeif7OU8TtzLbZjCKuUZWQZwmcBZNyjhpmLTPgiFIbFtse2vjNGlFhuCKsk5GNPHMm6khYYCrUrQV/Te9FcO+5w5qiHxAZNRf1wIC2cAywIKxQ7qPE8+GPXTt/oxOqskJMz3nc1uL2UIvZluavH3iBg09gJY2OOA3ZKz1Z1+j9lb756t+kLfzvEpanz+dpqhlKktqyU1Xqqvhelp0AxQjPwl38N9pk/E2jYRKbvHjWJqzTEFYuCET7ywIupFBCYAalpBwWcWu0ffo+hP0sBQpZFEdI+ODCUg7mIsVE3DETpdtm0BZ2JlJGKK5pyGUEW/SWI4vkwiJi2EXsUbsNnU++Bp3S/QXKWXQXETufNtOQDT5MwQYqRBMjyOP8dVFqk7bC3RFn4O/0jyashOGxdC+zoXCESoYVYyvih6TkXBzvknKLN9QoHpkqcB4Qbaah9NiODWraAuUIQtFRTqvMOy95spKtcNs28i3Czc8/048//IbI8gX9457ugarccJ23qq2Tl/rh4WiFG3OOMIYrlw8vRpPF+VHr1f0AwoQLCCvW5IJHhWC8RZazEwVWE2dnpe40XwtzzIMBdqzTUFFTeWouDPPRQUxCA4DMGDp0DhoqjGjnkwg1LspTbBM6D0ESCQvKLhKQpcRClhLrFEben80YguHI4vzJACq+kejbQxqKoxmWs7ckKbeDmts9pjxgS6QX8cxLPIO2Y94/WkIhwGJ5/34SaRl/xXHbsOnB8rgHND2jm9NQa4uOi0uGO485Va5sJ50DC7cVR66dZNFZxq/X9/T1V78VsjylZ5/Qp1uqsmBHwpdaY053+DV1Uoz9cFRyBjdsIY0pxkRfWD5iIrqDcrlLLJqrMcxCJJd5UeA4kV689qnG7v5eQ4jO9oakho6Fo1DlSVhGVH/ItDIWcIbHrBPQoXMQSek82Ie9Zii1Pgd1ttFp8pRoOTMqKQLeEDxwB/rwggU0oQlnIvW/096Ql7BAwxOpVUQx0W8gYnn/NXELOss0jzjKLqVzESldV4q6sMq3ZVK2wfiEO1Ony8BT8SMjOUKMNuZ2LGGhGGApACspa0sKKLHSqcmmlTLQE445WrCcPeESIabFHpZwZZFU8qQTxZTe6IrSTAvxFldbvqO3b34TZPmC/nFH9ytqIDcpgYzUGIHLhvQFhiN7NioyHFcHMETnLdxgGzvWgChD8JpeN+Z0tziMRXJpCjRsfXR2tpn1P0GqhdhfgFW4Q4gprqeYmFLEAyzmB1Hjyh5jAR/aY3JTjOiMebkyxd0po6D3rKNQXCCyKcnS/X7S0JRgCHadx++L2q3ZzB5j8SHIs3CFsI1lDj4FWhSmTNs9LGcUZiKpMLryQPHmNFS7LgGY1oua1HwctFuCcyQpdjuluG2JSbke+EvD6ibOhQkY0ve9oTglrftBoY8yuT/nmNL6gg6mqsQRqR3gRp+MQvO9B331f/99ZLmn+8/oCyApzjhWMaUEDaVCHG4qu8vs4x7Tii/LcERx4UjSWUWX4D0ntYXT4IOyi7KYfhd4SgFM6VvmgiexAnPRsv5ycCkDO/zGKDGUsb95xjRUZhUL+kFhDmowB8WBaCw0B4ixmJw91rvJjaEW83JpGoJEv9U7DUBh4goKS4FpaGBEJaQnEzVCFk7INNqi8Zb54s4FAy9xljRAsVTh9IkMd7pX24KU69MQn8AK5FNQr13Pfj8oiLhE+TQPnIZsNdFbmgBZbFBq64bhbvzBoMqxg4ksu0D/U7dByUIu+sbvvv7FXZb8bxGWu7IZfDJwmOuMEMNh0gnTUM2AYmLwdjhyqQWQixB6dFCqln9bDkgjrOCuIeZfhzJymXpzT6W5cOSzoOZCLsEIVOTOwzQmjR8kZfCLjCnDJ9J4CzWuLNS4Gk9RgbaI91EWAvGlB+nBSiojcwnes8m3cEII9OB2XSOKeRYkLxZmcbFWi1oqNLPgNIQUpsBms8165lIPo2fRVnTeEZ6CLsx9Y1aab9RRseq3U7p1tfTi1pdIiPlLHI6OTsTURYFjy18EYIVil618HFUxI5kgDieb8v12Lqm0syzcEY3qMTcdMFgZssDbe6c3r+nld/9NZLnQ5Qv6hzKUlYNwAcVE0WS+OK072z2/BudWu/qyiC8DUMwPirFdWs8SgVxcXUoteyydCy2W6WDW6nqtZeSYwzFDBaYkKUTCrTBTaTomjLFlzD7DFWrTVPaZ6FBvKEJGGTgiGs+drwR60lO5HKXmBJbYAiWxBBdj/iHP4p40FmvXAZyiJzfrsmKJtSyY4i9L/S0uDbGn43SusR1F3dJECjPXqUxSiYBShKcE7n8P8wVViMRmHJv67ADWmTqBCu6hzlowN3Ro6xkgk4ngqmFsvfXHHeopbeRp0Be1W2vOzGUk8Zu+WOHgegT1pHUQblvYS1zHn+PIK9EDaF7+wgXoX4Ysn9Dzp/TsnKTU89TcCkOr9OvhXXSOEpdZ1hdTt0tJqdxoUaNSS0he4kmJJuVul56LHjRaoMcf0cSdaZ4FawdzoXKQz0H2c7tNLjNnIucmEGyZ+osG6ixZ18jcn4kvmltR43lKmJt4SyIsYSaCnu0edBbLs2yq5KA2wTqfQm6FsCZuls7B2qGCS/fhiHHRwUzoHor1CjhBRebJ0yPR55ORzkTcucyoC5UuLA4rWEw5krVMJPP8N18ypAArbv0QRFQgHdfjEpAbyR2uQxAuuD9C7dCv3KbEi+PPEW3jI6kn4zW7dFzb6buJtqTrr376ZfbzL0CWSvVz+sfSwDIow+WmQ2SjUAKUDb5cYg/DSnBqyONx3DlKyi5popdjZTcBkRGI5wqMTqxfYd1L3C4ToRUtsxeOi1IV0gnoqk6QeITUvWdDFlK99lAiw+BAB3llOE0gr5BzEyyLGhrNEE0KTEmpbdsdor5U4eqgwcIXjkOQn7hq5SzC1pZAzlYCPZkxltn/pH6ZJeLAhG46UoH9jHsPBdDTcHkgy9halD5EFi2Rmt9+Z3GTqHtzQlPNZfbCoVW0pm/XplvzmxNVWQygtTuurRFb2Yw/LcbeJqYAH1m3nPEiMpreNhnc1knw+kFf/4t6/y8gyxN69gk9X9YL60mApVb3icP1y/IV6hLe/Qh8weFoaLQXyOxyCUG4+dVIA7s1NLb4HiNTv+St6HGSX9VTbrBvIfW2EIIL88CRApt1nQd/mZOOiSxNuYy5Rb43FAVduMj63tFnx41Lj7DijS1jUogLii16z6OrZUnNeUVLn+CCG8yGKdjSEoRbgxIKp3+gUltOhqCwZzhHHpByR1ZF16xUndUF6HGluf1MBit9Mi/lbsIyYYXBMEqhOMp+c1tOgG+xmQVPVkW1Zd6r5MCBkZbWYqi/6bvghj8iOiSDecLH4vu0OBC1lmNyK09J19+8oh++/y8gy+damLAgy5q+vTUi1Z0/Xfer0gW1lcuyIlDDoiN2cTMUXzJ0L6AK46tD8WRFKiEaN53myzw1sV1A3I2R3Fn1dKGiow1LOSJJUXFRrWWVVw6eM5E2JxRjLhJnIkx2gF0ShyBkKxrYRacZW6AozEH71aHoDVmShaKUy0ZPll3E8ACC/EHN7XO4Q71WZRRQVYzOgHrCssCKBoImDBmsRAozBV1xybaQ9I3N3Bj8IAnCbZMlxmIpW4KeFIqLyzGJ29ZWpzj+HDDaIAFJKskNTEn20O0Yi1+38MuVvvnXr40sT+jpJ/QcoGFtTthc2bpFaVC6hFNBMqNZxp/xAgOU9Ol2OKqq8nZlVQxNUYYptbqwQpqs42Q515BnEci8gD00VI+JI9Ns1g26rvdbm3G4IqDgqmpboB5BKUyIb+D64mg8GRykSGqxxMlIQy6xFje04aIxZMc/W5eC7QESXQBWUvo20ZaqeTkW94yS+4O/TmMbrCLCqEtHOWnaPVNeWTIsA1B8sbNP+9lzQHqROw3mggpu97C/aS5BYdkVO3XaG0NtXTKk2GsbNwzdijZMkRylRYUlWTzbXaGmlf0fiLHAkCUtAM3Lbz5Wx/1YZPmUPntCT86QZZtqqefOdF0kmDReXZaelzj+1Lu4snS5NRxR3JzmZFHH1UTS3sxZagtGEkHXf4emKEJwcck2gIuGaIuSkQJrzYX8fkhJlmUmUm0ircaM+7Dhug1Z8zZ1UGGshyVG+xnS/WxOa9pLhL2hdDRihc3DAueuFit2oqhbCxWazCW1T8Yt54wmSWop3fkLRR3Xmz2dsECmLsDKsJCkCPZOGos54Hz48dRBRFa2QuA390hqxBd/UorfX3wTUwYWrEuDSbVNXvKxQ4qtu2y5/sxfFjlmhv3f0bdf/3rIUqh8Qf+ztiKUZZzhyEosXxsvrqG4faCuboK5bJCx/fR8OErBuRTARaDZdFnWfORz1UOHS1gasnzKRBNxcBl2clFKEkyilJdTMOKReQGvmjpX34QOM9E0X7wRyn+ws24MMSwNadRFuPEsZ7GN56VFweMtqrP4/iEwF0OTpe1JKPrNBUTcQsF+Lj0U6C1oEmO1QyfuQX7y5j31wkrn0oU6l0htDFYqCLrQFNc49D8FhSXtHwpUqyxjkQdnB8eBwSfk9Ckc4nFEHycZPW1pRWg7DtJ23SuzcW4VbuMwlUSZ8enX/6LefiVk+ZRePKanpsuWnQRbsnB7aziqy7wTISa70WhjX6hcwI2yrB04TT4cwc4Rx2ALw5Ejsquhs7UAsqWhArKLrhGNEYkKkU00NAacKbJQBBeew1FpZgAp0Fjwf0gwBIGOTkODrCDoznq34dH2dCs6lLjZbP6RfaqHw/vBZjAWYRLX94YwKbfE5CAgF8Is0xFXhkK0q3fqwTYywSgGWOb1qgaW5Wsnm4MwYbxuxGROeZGtDKAxQbep/bwJ8qc+SjSGOJRO+mFmRz4JxE9fJq+Aw54EHH/GjX2Fg8dWL7nF13tcJQbe2hKB88FnYTTzqYQ1jX76gV79/Cshy+dzUWgfkFtHpGVXKL3YVZJljSj4Rxi3W19wWVaQKiRl4DrTjNVVWE2swE2qqrY1gg6qLV2fteBcL75PVAqRlMaVImchD8hZMLSopILRONhOnM40dzRThMdFlFoENN0h0KCfSniCIrAYd5rVMMLtIUzN9Vgu14POUnUpkcQ75VC4JYi3KJpIEfasLYAL48ZzByHGF53he4/0ZKonI2trjXywl8gq1k7ZRXODY5IyWXcKuo1KD2vNcCqKLLDi8GFUhaNuIrkCakq5Nu+MmjhybnI9AFNi7G07DW3l2GMnmqwC7bFcmQHc3TQ0kOVo9PX//hrIcqG7z+hLuM+zqgI8Jcdtb8RwV4n3skgtO+coZ1su2TkK+HIJbVKeZwHniICnCBzYaNaPtbqEvFwNVf5zxhnAMZPm1eQVDcg54rCTmoEOlceNpCExDLnk3gCFFZ8O9Md+cqMlx3D9DPkea+XWOoU1idu8YbfeKk8IDducJqCQZ8l9lDYiDRaGwq1ZxfP7BUbj9bdgCVHjohXc5gHxoq0grBjocJdxkhGpnrI0sIQrYAAdEmufZNkMIj/3xweiBVNGQ8LkKQ14igSkWDeAjiMzl5WnDBH3aBvmkgafdYdoXPzua7q+/4+R5QV9ca/HCUUC4ll+XBHikJQN76oLhambRsuJXGk/YMGXC05PlwBP/uyYlaJzFLq461IuV/w0Ik49/jVUtAy+Q4XU65lz0OEZFh2LQrR/GEDVFhSP6TpXDlGOgCMu8epPbLK7S/v9u5BMFcZPNQsLiooyhw1HUKQg8WCz6DdbMDecc0hep8DQrV2wZ1tPa7ZRyLFDHWj2BlzbNhQe34uuBTEsMbNPQKA39TAcDe+Zgyu011YIEMd6s0qn0h01YCbC5NukKqT5FIrlTN27WlrzwkozoVGpvUYV9rqsCybGgRjUlKTIqvXuZpy2ZS44Xi2gg9NQ7/TqZ/rp+/8MWZj4c/qfC1UGzpJkFBhqwsVLgJ7NyLNYyxuSsn1NjfiigBJoziWHege+cI0nAWirdtHQygUkXobDoedawCiLqzPb0kd0Rap2rKATZCSFD672qTEX9ZsVXIgb1SjrMppKop8KHG8m1rSg+DKEmKZWdEcdd6IPBnNHfwLqLIG2tHRS4DR6S2xRqEpYHE00dFu8hEWqaOlv3G82kmKgU2HiI+NoqCjBcFfVckYcQVeodFtEnNZ7AYXFW/h0q2heHztA4QjEkGGxY5sFjoVHqkL7bcNmG0PKTY7oCreosyaFxT9tOb9/qtqi3Ntu5eKS8pKGLHtvO+ib//tAiyV/qDPh8XP6vGyy/BtKwpBGWWjIB7ItyXtG/nKJvVAJUEomLPnTCsGZC+wE6NZ1OE0RMrgMIksqXmBLvjAbN+lDZAH3R5KwYhfBeJ432NQUcG9obhvpe9MP7ShJ+PpvwVoWwjkIIAZghZo3VKfIXDjaWUI/S9obwpLKCm1PKXFbgK3EBjnAmh6jcVCgXXTuI18U0rfE3Apa8ju2MvchEqyMHwzSpQ5VW0MusNzsZxUWwBftzT6WHpa2ZuRUUlk1lCPCwXUpW8HNQ1N5b6BMYi4rSWnxC26noZSaswc/fEfv3vwHyPKCvryn+xIDLAolWW1J5Qmrl3RZDKMERtHcQUUmzUdhYqrRPwJ8sYFrohgOR3b42dIXRVBAF05N1GdZtw07o/0xRp66gsuQVMaP6IaaS6hQQNzh+dWEuic+wkwkvuLsLEAnoIJhXIk3nugpH1qkhGxl2ynH2M8ikbMYynQqjBkWE3SVm1AAROQypNKSm9M9nl4W9rYnO9Odw7hFpSACS0OQkWseZkFYMR2Xm2dblMV0Eu/iF4USot7pYMWFgb4Nxp/Unh1rKFun99CAfUTucI0QYwjimDLAAk4g22wJtcmGpO+noVVhMZLS22axKF18+5p++O7fRRYm/oL+3xqNQzm27i5qj+SAng9m/3EfOi9D1916NIR3XVKxYrrqWTs2uLmDzaMBVXeOLwNTWMt0LynSYkCjhS8zmEtFpFy58nSUK6BJxYFIYD4akAGwUuL9VlqwY4vfYOY6K3mhVcqFpP/KYmzRGWXReDDrJtIiYW+I+2ZXKKVvGZoo9YHUzkRwXUTm1BOGIwqtVzoQdRCV7Dsdmm4jiRfRWmZgK0V96AJq7gz7d+ZmBQvAdEYzeXeqwl5J6VSlex2UjznQ9oSOcpp3XFLR3Bq6vyl6e6T7XwccfEtXnOq7MadtbaCVniTxpW1MonbQtzcXFG8hyyN6/KmPQpuA3JKU20Rd1qlnMZvXA0OCW1Rhp7EuO42pe6HGqt1LtJPu4He5RGfaDksEZdfWhQa7YaxW4BKxoIpRlZlbL1OS8Nh+jQHcDazglNSnu+HBOYpnp2MqF6LxfshGgwZZiZoLtMkFWOleqjABBfK4RDDKAaxYA+6m+Qkjc0ZPYDiyMAseDl9ERLhoiqcIzZybNSEoxdP1Hx+LGDhLnIbcgQ42UJuchVBwaa68DOYi87QQXBHy7ltUajHM0unaiVRSQTJyxMXC6+IlX69TG27GSpayuBadIByvAklZDCN/+85aTv1yWcrV6z/e7Mfl267QHT1Oy4dlF2DBWYazo4zd2tlLuuwydatUfNkLLnlbGgYix5dLTOuCuBt0mRoGImzkxjmI5l7iqDWo5gQ1KY1rMT4yjOSJIFWV2jO1hZP4orVyE4yGTMtWc2nap4VZIOFiY5GgBKP9/h1coeZu7uxVkF2eJbrO1EOxdtp4jvvNQsIxLBf1FIKdQw/LzWeLOc1JoBUy36cAHCSRxaY/wnUhhJVGJrjgaSrKU8heRp1qFxakKoGesB7cIXEtCMYfxJEhynaAifdQnZ+2Ctsuqn/sBp/tjvIVpqGzi1sMSrxmZTS90ds39MO3vxxZdBRKJGXlJqXssy155EFtpW4SdOsGQCY1UMQdthmrT0Dh0zr3iS6JpNT56Th9MeHLmHQuNcRwOcZbmCrIIvNkL9G15jEKGUZAHtcdorWcReK+onhdblHnuDJxgxLZpjPRlHjTWJQC/ktdy1mVfzxAPp0KYrX7nrKl/elCG6kllsihmuviUQ81/TTr+N0JKqlUXBNx428D2Aem+KfCwp1Lm8JKzN1OQ02AvJTO3BTFOnFbs/xNz11tHcafFkJxrdPVBBSIlrTk+yimYHv2dRlzju2VhXdcY84FiY/rNdtQ//ms1Fdlt9G350l/vuEK4Sh0pqd88FmlKsmQHviSDezLwnQuS59ujSvR0SGydJwBSuA7dQnvGvTc5eGIiksq1UoqK1UqfeomdTwoVOxMUjWeg85iL9vJt2E+IpRy9cAQgeC/2Ib0pr/e+xYAU2AHB04mgtOd4ezn/dlD4QRFiZtBoLkQ4Soz4R6zqS2UmrR72OTWfYVBrKZ0lZJ+M+cmXI2PWH6/cdRWUHbRYG7Tykt3oGdnDftikVADHbeZoNu6NmYnpdbWDskbEq4AHCOQ0sAAPrB8v9F7feUchZbc7QGpORx8EA6OJcDSon+chppND0uqfToZi5r+YW44RKfI8pw+v6fHcQKqH5yM1Em5bKMuS+AFD2wNlCcNRElegRknPMtTqc2ExRJ0EV98b8BmpUsonULOMpVdGtmT6tvMUrvvClV23CltLuMN45kP0Fkkkpe+4Syzq2X8W9fwvvdaiubiUlI+92/H1FzfMBeKZ8u7GURQ+NQ8g5tOBbETnctyuhAtfdoawM39LPPOV1gkX++ejMyE55LUIsj14/iTJiNwl8Oi80zrQii5Nv8ig8UUHYtKFxJsY2kC/bUg5R6AFAcwEecpaT8I2icxVttirNYVmUVecavoJMCyqWs5wZS+i+Fart/Mo/GuN6/op5e/BFmY+DP6Hx0r9q7Qgi+3iMzuEMV6VqqwMpSUZynRga5gQiWOU0NDXZieIo7UO6iwuwTxpWOXgs5Bs0NkkpEKdk9dorcThnjHWdJjQqyZZpB9yqAQ6y6SSbxrwQJATBqIdI6gTizMaXWoL0eaNTiKR/wkkAp6LcckLh4Agn5zQJPB5oRh/JlwSTEXl075YLHTqeE71ZAbxQwLR52F0RtqwFngU6MqHnUxQbeNaoUWA7X2eGoo4qav1Rqk6eYKs0nDYv0FcTzdvz2G2VDmpDDBgOBQJrIqLN6qvabpdppLcoikfzSy3NH9c/oSAeVMly0LWCyWEBb6b9eCNlUvWzRJiwKXKMGkWobbkbkaRNzpQF/gXVF8IfWDdM9warek6iyj0yylc2VVc/UFdaUn01eeJ/sVmBRi9wKqthYGUYtE5rPutoSjzoIeYUMH/Mz3AG5q2xZcU+whz1KTZMs50Y/TkP8xVB4a1AZ8MRHhoVgRNGwzZOFmW2UH17z7giKouUuqJQdtpXQe+UDLzlX4Hi+6LTVeIE2XABrVTqWLdM/ONersftAVcOSINlDClBHt75iIa3vashVTVv/YDwbZddxugeY0ETfeZW+5yXF6o++/oeu7j0aWT+jFI3p6FpBbh52U0D3XXDZ05nJCdi7LGSOXZURaz2O8RMJyOX82+UcwH23ElzoLKMUBotK0hIoRGeQsnQuNf4uEGdwaUWPsChWx+gV0iPwY4wI/3nVQCq0uDOiDCi7puvASySWO64gu4lqJP8EQZK5zX6rkoitUluMQsfKW8VxEc5TdLPeSBAj1hzIn9ICspJIn6GzmIPu16DlCpUdTqcFXm5MRcJYBWw03oYVkJFaubZ5SdkBA9gBz54BE3BEnFKx0whLJFtMrbdktTKm5tvjHCWjWVIvH55awXLgY3yUnLOb1j/Tzjx+NLJ/RPy90x6cMpX4oPheoyloQFfHF7ny0pevukPm8kbiN/FfPrXgBHco9l+hPG44AfxlYQ5XuCpV7qpWK5mvNb27AWRJ5iUuJ9YCY3JikZrJOuGsVLu5A+0zkAVZP0IXASzxzft6cZNCD8kpBp5m0pqRFfCHYb5Yl3Z84y27LmeEPyXoOwUQTAhc5meKqGQ3OYsuEhi/W2+QtVirfxt7JMASFFecW1hHVUXYfGiBmIMjka9WvCE3EsRPgp/gqzk38MdjMRypnOuiI1ZNp2/i6JO6PXRtTWGLeVvafpFdSVP+Mj9iWs5xPRu1K3/7fxyFLofoZ/bPcUlJWQNkYQEvYf/06mNlPebnLUhxVMM5flo1nWDJCwoKetL/l4qIMBnYvhjUjy+urRsylChemQq6q1GQSMdW+F1xq8/pb7aAePrTCSo/g4jfndIIs5us9bG2WNnhkrvE4Mm1U2w0lZZ4ulkpbdt6znxNiORdsk2uewR06S3CITHCJ5U/V14LwsCEq4scJQNekkyzClIomdybQOHYICVsZpSQ0aQqmPc1Ks/6q7KgKDSdo8YZI2c1YVhQxPhIwZci3+hhRI9nM6CK3SEla32EKko6zqgSUZnZZ/lxGeW42n9nMwSRSqPru/zbe8wZZHtPTZ/SiUOWFpySusVKSBAq7gWh7vVxyKAZXAZLBtEnuXkASXj3pC7wFQaSCx7SY0PNlA4Bm/X8lLgLjz/jp3XRK2m0nTsGFqfSBL1ry1H0boJr4YuCiY4IFPWzIYl+VniJFCbVJQkJVVss5V0CmPIvnbqOUO4cj6JRLldpl6XyCUFx4zMvB1WaZUw/BFsv1ea4/JuK8Y0UCPSnazEIaXeHIXIx9zFRLA4LTsP9JJyzQWRRxhHqTZjLtFYDjvYmyqWsSnlqTKUfc8WnJ2QFh5Yght2OHHW2b7o+HIt4SaHddUCjZdslv/OklvX31EcjyXKO3Z3PQuMk585d6kpc7LWopy+LisiWQ1oUChEW9du8i1Q2CBP5SfVyy4cgXIO+GmV2YdUU64ksajsaVg0tRhYUMZTTYYlhDi+Wc4KkxHqNRzNvudkzyrF+wdqgpuOhcU7rovcqcTyzdqS14WCJBzzaeNwTV/KmqMvAUIjzKvoL3TCJTNLF+Odse6nr+Yfd1hJL4C6wXghoNlZRtiCOD5mgB5bR4xrg0rSWFlam2kDMUsJkDZwmZfumOKZ3eHxtLqC0uz3Xxld8vusk13tUH2kbbipZlROp9o9eu5MWpTRyUwtdc+cvy9d+9pR+++Qhk+Yz+H7rCrDSET3nKrYmp5lCc7SuWev72lK+rcdgp+YSzS90cRbQxiSqASF1KGO7gj+TaLRds/ecqZQCNHRNfm599ETlIyMvNxSIGjhPqFDarQ8WSchL8acY0nWXh5x6Ankxo8XnTOzrsEEGLJaXj5SVX+YdpSLyNpe5C/aaq2KGrMXcbK8GttbfTwBSjadJM3FX6INYOF0Jx5igT6LgWlqtjUbl5cwKpi2wZOQLJ1rYTLeeidAY6J3XlsM85qIkn3JKv3DXV0lpY6rme1WWDurE5xKPlc8v8lWebyhGVcLTZYs16zFA/4S84Fn37vx9ClgvdP6cv0t3Ou0FmiwhnRKbuzOmaI3P5q12yEmz0JOi14BNlm7mEYC5G+0PQ7gIuUgUX6UKlFB6BuQqVUOT4koYjc4XEzzBzt8iEGIMek1dwW5qCTFv3i9E6IuH2M+w3koi3vRDbCdDUqFDscDGIkXyMPK4+J9eZY+fTkuhPZtDkKVV/o0pkI09I3EALP57KbDF/yk7QRBlM3K6zj1jgpQV5xV9vPnSLVyamNBlzUMP8ytH7wJFrD51vSEywIA7VXBR0EXE8gxv7Jdu2bT8KN4nRSN+Ql97OJ50TPWV9gSwv+P4rOq43keUZPX9Ez8pNEKkn/OV89Xlfs3DSyVDqrgRzzdddNlUMqRcqvFFfQBe6WzaJzId2d6kQV66MvZX4ayGqwoVLJWbhylHQ7SrcGnkpxmhiz/ZornTt1gYfz/hXzn10nIBm8hcqjQmmjxjGhWkonB+isGLDhYSMXGAu0M/CEqoqS9xvDq5QWLmm1Oo0K287icfkJteIRyCGNR8XX2VjDFH0etToCVSFU3i/rbl+wxRbORzJ/kOm09S6XKOL3CDVcgV8WSP8LS7mHIvX07Deqe0anhZddqvXekRlwZrZcblTTwIGnY9Ls7/yR3r9401k+YQ+v6cnaPqs+ZTlQTKGViKzf8Flt3C07ViINS4lDUoXBaO6LEzXJVlXY5t3jS614cv8IoWpCFcYf+b+goxalhprF0DQJcAR2y1yAWW22E90aDRhiNU86pyE26KFLKOZgZq+XU+M9xt7irgzX1vwqDPRmCmF8SepLYgy1MIaEcsHVpxZ0eQC9dpalAkQ0/SVWolAsIXoqRZLlMBYxLliElFGBZHmByHqZjPNnaBjrg5ZJ8tI2UrnouBS/CQy0uFjzEGHN962Ll2op6xKWxZ/1sHnCpPL0XNKpUUDCJsNtoJLi5tBYaKJX6TFASqwj/hGWfWXE0xpB0mn94vUwjdEllVb2coifNMwKjnXf9mSoLpDqHqy03jZsZ67jcISuhcKoEYJCIIBf6i2ZKbC2ogrXNnPl18uWuElzxkhDUewZHhhD/LXGPDPOV3yA4wMU8x7Zsj++5oiNjNglf/CX1bvWewkI5yG8GCQqLNgpxzHaQj7Yi7kx4A4T4m/uzlBkJSDDEsPRw7k1hU7Fl7FEUKTqEHrbXMM8vNA8vgj4SjU1qUzh7MMhVqX+Uqi/r6JgHZrTddDi23LRBMmo+gQDf0lEYe1Uy6oMDuWkeamj1FPfBRa9JrNPLVqOgd997/nyHJHjz6hz8vNSYdPZpmyb6g8BZp6ntatOwCqe3M65+tqzK0UjaWUmL5d2+eM9dxpzoXLQA3hwhM1xmMDkajpTvGlErMUH46szJE8MgcYIdz5QiHVwsKXDie3ds470HYisrVMkZ2mPj0XyOY6psxDdpA7gGSLgu7mJNbztkqO5QkrvrBm9glyfcpchBsxhcOSip7laC0tmuhTWwcztWLTTRBZFDIC6Kxz0HB/FGWwe9+0laZD0PCb7ZXjBV162us5mkq52odyxLaENM6EApe21NymqG7MreSjP87Uk/OYnCga9nMbaLujmOJzP8SjQjiWyD19Si9AScne8G7S+aiJqZ685oYiE8vi8sFpl2xaZ6fpTnEHVwRASXEMKssC9OyCmersgKWJL5yxRk+B9heo+DKd6TkceUSlakfckDOrHatuVvSs+5eq8dNCvHIZJmiZWlaKSxd9zBValHKkJUHMaIGimGeJ/Sw1EhZG2SX13UpgK2gMDbCIm01TcylNSMzHER+XYBoKnzY82WPOQaXxJn3b4DAQ2z9sSVIR6l2mPdSgt/+Ygktr1JsczDJ5DWRb0GM+bPC5scoce7Ozm5O03o+0k5dA3Sk9WcO1ScT9iGkIpZY3P54gy1N68ZieITfBqYQ/xETiTJStpd3hIeuctVFk6g6ALvD6k+NE3GBazg+pJVRw52xupVK48OynlGIzEWCKMxQlL7US8TzuaKgz1Ycj0eGocWhv6d454HY1dik0GK/WOku2o6DnoV/uNy+xNDvX2ZIvAVzgoDJKSdwG5AWCtkFn6XMvke3ceK3RJtWSMOTiu0Jwjuq0zMWL4NinIXusPAXTKBCQU5lWSmdptsdIqNSOwC7PbaBOrUlnboAprtcieUHQAXG3NZEj7gpeYy4O7/8Gi86p2aDt0m7rms+WtqAW009coRvGUL9hDH3cg7ev6OeXJ8jygv5Hb+yNkmIkxUIufD4Nca6b2wRezpTdumwYpZMY07rAJdd3J+EGo3QmrKwdUWZF10Jlko46Z5+axBSLzLFw5fECAueI4mkjccNo3v+DkkgRrnE7sVoMNy0EqHDjR7I27Kmb3lDBJWOsxR0SBoE3RDCVbGEFulpGD2zSWap4Ay7rZpCrOaIbjOLHM5YuRDSSb+NcIZlJfC+UMx/Hq56spaVhaMUzLOgcG1VxwSXOQSa4xI59PVPItoJ6l0ln4AizHksUJiqhFhv6VmIz04E3+W6f8Dhpom3nSu1x4igbTNgOtCyiiWjvv+zgRpY/gJyAizQ63tPLf+2Qham8oP+pm1B/FlkWEHGA4JOJqd70sG/Iw1tFpu7TdCHFW893jqoH/H2vGvClFqZh/ZSII4vsYoQlSLnmGdkZi/YaUHZboDPeemk70zOxAsXdMtiQqrkhm+vHiXCXav1sNg2Z60xwUBHBgSHgPadjEm2HiDpkcOGkIQyzEIWDhMYD6RTywQI8xY9PdS5DTYlVaH6zgFxOyo3QPcdcf94zbKDjmkzromzqzHYWA+QF8UUPaJ4+0dElhVbwbj+Wc1FN60UD+NgJHCkFF3J0Vz3sdSeydjkXTdTT+aDv09vm60hKyunFl7BAxJiR+5S+5A/NO7/INlrBKE4rmRDpgFNXsnPZkaAa/Z31uJK6O5QezKD1DMZyocuKKSavzGPl6xyRkKpQkaIcB2MvCD1UZostVYjqFiQs4pGWChvPWM7gKDPbGKhSKJotPWfVQjtU7FUoQmKo1HTdGfK4zlxwDhpfloPaYic3eidmVn/QXdZuhHBU0NyijM3YngmeW4sIKNgCBZUIah4PL1nBpTGL1sLNu8aYi3rJcyBCHGkwBHVpwo4vwyci6tfmp6CizpKqVVK9flvSbqGsv52sMrddmCXihaxm8zncGIVZXyM7T3r8jhT/hD9CVwujyIKdLOdZOCMpJqOcMhFeJpfFWjr1ocuCQbt2hUBYLotSc4lrSml1KAVY5lu4GDpk+TZTGB+X/HHMv3ClwsKVSyVi4QufDUcQgYEOlyH0apHCWJKeNnP1vgWwhKAN0wsWbLeox1KopLbEhAtuPHvOhYiFLtpQSTAQ2YM1zm9oUjqJHnViZXH2xSvsLltPbdZrtcCJOluzJAPKFK1uqvMBjj8ROCYf6dFLJupNTWUB8tLo/zP3rluS3TbSKEDualmSbzO+zfs/3Njjm3yTZHVtEucHCSAAkruqJc13RkurV3ZWVlbLVoYCEYFAwyRuB5NofG8X6aCzWAYftVucLHKxfiqyjbjw8UBP2s4DRuXlNOl03Rtoy2tOUHJyhbyr5W/07b8WZPmSfvmBvtgxjr3mAkdXy8M0hHUKW9mFPeD/JLvwgkFW2sSbCwGpY8HMZu+1rNOQDt5QpVJK8f5b5SbFiYlDBm+ojcGKDk1+utVoi79Dir0MHIEIjOksrBCj6V5jJT5PdWGhShDPtdlHsNRytwDdww35mcGlOAo111msWxv9Zj9CQCTLfVi7KOS9Kopi099RZLQ4P5TFWROlWtHNq5tqF9bw24jeqpeMMZaBEZN3SKepnsyLqQ4Z0kQJy2iMS2pup9blVuIThynpd7ysjAdStxBjgdpVkb0jA0pC7L3zgF30PQgruDHU9J0f/OYG6duHl4na0vdH+vsfF2T5Of2m0sv6sa+ZlTzpKWgw89vZufoetrKzlrYKS3ge1wLQor6WNaUrHjDiqKcg+7BRKDlE6Xm2sWgA0Dgifc1wHU5MXIQDVbG8nMZkr5iIq7SencfWbnWaaU5P3KhwOO6DhUwhNbeeChFtTsCl5+U0Iql1RRycb/SbSas5DUoottuaM+U5N7/oLjLraSegFNBZrKJphGvn3Nc84E9dGDYJPfamS4biuIPCisQhyK590OxICJyl6Xhl1s9aJYmLPA3kGFlUldPKTztsHueC/oPdM3RiOSdWZJFpt3ptUzSRuHkgje7v6G8JWQqVn9NvIxwcOQj4PptRiKOcwbHK/7B/dGQrp4nJvlSW7qgSGxJi+tZ507JVVCuVqqMQgR/k60KQcLEw7vSb5wsWWAlvMr808Kj4hTSZYblqFVAdtNu5KzBFzbnHyDFH16GXm7yACi9PhzuEKnMUrLC0pBxFEVeyzmKt2kzemTDAJXVTWp3dlGklrhrGZC27bIyryZZbASeoUe0ijauYo+x5Oe1SIYucUDei0dzuuWlYwzr7zOTbJCC3sNjgwwpPTUwADsbz+K5XzeNuRx7faV67rxdVpZ02khGG2hvVB7dJIQeMkF2EX86v77vZSkDN/er3s3CbTb79qVdqZ7rBx9VnQ59nF2ndD3pj4/GB49Tdi0/LASuRqUusDneI2BoSInDMUQgwAsygaTzjjmKUYALEcPrSbjiKgssEmizNXgKlUASHAchvrePjkMddO/2RaGAnLpbLQcrWpiFzi1IoznScGFqZVXJ4xpB7SMoJnC7EMrehK+MzqNTy7E9h1XH9SGFkJT2othNcEmHRW8ywIqQS7+yKky5svx2abhulLWtKbbtY6Bc/es7y99iVnSNz8C2yWwh6sHu87elZpt29m+wqFGSps/zXX+njt4AsH+jzL+iXkacgQ1mV2g36WBXLw8siW+FTfKZuahlWyKjnFaRc11CXpYFrd4YxxVgSLtQl5EI18JqwTxQnKY40Z9Cf6kb1oDMSbj9XJC9Chfy2EVx3nbJuTavPPQNNqFkgKMeVKal4nMSycxQPsMINkFSegNeFMH07Er1xjcAbfKPpY7tCZHXW1PG+8lwdhNa4lLIdD3DGERh5bCZCm7lTZ2UfPvg4eQFZ1/Eluc4ASdL6aZsZJppVPdlHZh8tZNRcThptWFaWvUSCwZa+YyWyII7gnBVB519f0cevAVk+9/KEI2fB4WVRUvZUxdDhIZhbNrm4DT86acBQUnctl6TnebO0WIREpqLiy5UCoEipUM5SE6aguLtQGB2REE12WANB3ogvwo0vGHb8KJpQ9TXooLZU8qkHehhmv1yB80MmspSUmjPjGWsryY86Y7o/LwcRAIrkckzq3ndLzScjjvcMxyqQ3XKeB6e7d9OCesKwl8y1CXViA4UglFDcJ0wBFszyp7AcqLYIVeF9gPK00atwp/Dbjp605rm4bYXKCS9Wd3njHJ+hpMOyYkt4sZpH2x3oM5GRRt9qncJElp/Rryp9drCBsuCyAE2gKnxEEBeD6wHC6n6G2sReLCa36ruVmCHyX5ZsS2yWAlArXDRsR5jZVxAxtQVU28xHqjGXupjWZg+NoQnmo2LzVIj5jvj/rMumC3sVBMJyWiuXAAUL67zOsuDNVjzbHnxo9J492IKcRXUWgyqSUKlN0RhKR9TCTARNCOFEmf22hRMfViipuz/CN7GYKCsuiNjn3wlLl9bZMnJmLQMeSRedjJrcsy4LZVrAFLIfp1KLSMe7QveSVQmRljUR1/d2z/OkM6CkyVkiAcRJL9vOQV0lmKZ3EeUxLCc6E71+R//4Y0CWeQZk+cAzU41tlRtld9FxCwcGcSRBNdhPx5koibi8jEUrBl0H1eZSTLziFlKlOiiD4UKafZybbDzmOA3ZDDXi/xenPaMChMW+hTm9+XwNtM/Fg0dT2fVZaQMoIN9qFgalXLjdweDpIL5QD70KTGEgIrgEYhtDqN2UTgKXQHDwIajULxhLkfDb8BqtbrLxh6dJrLDiaRQMuXE0m2040tdM5iKwxGx5FnWF5vs35TIURNxpSw9/Os01905tbedJp63tKofl4wFb8lhea28i5/C+nxNK/tFW0F2oSrtJGnUhaXS/0t//4MjCv6DfJZ7CB1zgsPizn4P4ULv95uj0QFUK7PuUXTVvPeTrbL0gRXXtmRlyUVdokg6bZWAy4oQaRlWKlMuKoGAystK5jU8UBN3iQ5NbS5DxlSnisvo+FbYWfb+RYmNuWG70EJ0HW2LkH41nJreExnCE09Awm731NtZTmhLs+X2Jeq1I6SyxCG6OPJ2G44N5fLhABsnaTnx3Uqoindg12jn+SCOOaRR1fMQjLU1wUchZiXtGoxaOQhGUfdUCLyMv04h673KygdpBGTk5QRJ74SapWT7w2COZ8Eh205akx2fUSD9FDq9Ee+hv/00ytLuLPnzp3beOIwdwce2DQ+ylMFgz/LaOu6EqvBuF6iE+E9sV8o+4nu6Q1PVMfWE2X5krBuFGE6WSkWQ2YxEUQInBTS6jq0LasUCVDcWWBN0UXErhOYtNcVfgsDSFaajS0sUtcC6aQH/psaWp+/mxBCtmQs+lxO4NlRTuN09wCdaS+FqQGc/JXebYL8nmN3c4CTI/wAzHg4Qa8aQek6HoCKM85QbLOcsr0xiSOUP1OAH1UHnb+m4CMvNIk3UNFota6yLLcZ/73pSq9AboE6FkfIznd7UnM2gkWeSgzmI67gE10oDTIlg8Q0marf7xZ7q/m8jy2UCWZWYJQ80WaPhJUgmC6zM2PYgvvBycLxnCwljE+zWiTTQG9RfMxRXIpxAMO4nIlCoERXMmrIywP1VnK+MHz3T/EuSdZVEX7DQqNtXKc0YrY5gCDaUK5OvspJF1LBDVMTjAecZQf92XcqYlO0exIne0KFxGUiicWDXtFkUWCN3qjCNZtS3qPc15p2mbZBe+dQVRU3B0C0tXNPFfYVkZPv+zSKVTkzwBWSrX9JFbWGyiQXqiuOMDUddxyV5vxvMgO61vZNQVZWTX9va22tKe4ifGRDA7tx1wGugjONSs8u3zfCQRib7+G338mpiIPtAXn9MvTpDBC79YIKOWdwDNAwkyVYV9eMlnALauk6XsYptMEHrLvgFzyb+4QAvZWZBsQZH1DAvyGsQjm5gIcnQejathy/HkT8tsq1P+UnlkeW2JUcP+bjl7YLd2v1sYTaKJMngO1ZeJCEQWyRfOSGYWrojbQwzRfpJcguk6biPRGkpaDqSS52vnojM3QJ+mZ4OwxAD5grU0NZIujN0IHkKxSgRYXw5JFrSlox8U6Am+QCAmhz7RprfpoNquULLN3Z4YRNuxkocB52Gf8AQlAn8egj2jLW2RRl9/Rd8NZPmC/vMD/WQdgnixezh33+KLzax5Q3nBNZ9dA8N2kbpWKnTQcaM0k/NyHG6GHNYCmKf7A/iS9RSTXa1gITnKywNaflurMpE0RukQVKd5hDqL1MIDZeZ7qvhCpY/d6NC562ePCKahCQd6fx7jLRQdYoomUdpLVNd5ghG7wUzLCiIeqNecG4nkOlvKB1LtHKp/iRVN5qbPLST6OHfTKgeZQNCRmNh8pDQkReDUhPbRBtUWzNGlmQgU3ybUW5d2MozbvqutLYizfrAlQVU/Djgtjk5tmZie7SGJQf43JyB88t//pG/+PpHllx/oC964y85NFnCpJySqEVzqI9Ds9huxwm6zNBDHH8SjUPddI/HhCFIldFlWZh5mEEVf2QYZ96FBcFmAw83j8ALN75YEN2Ab1cJk0JOs6yK1spRoJM1+BjV6aypeAJMIT6bh0mDBrtxlU3E4R4RSLkxDTK6t8Jq+Bbm3RFVlBufQCWo+IhWEklu/cWiuKUsyNwlDeYrcwpsCJxtV4uuDtiLwfCI1ClvWnLAmXJzyuKw79p5Bml0nI1xW7rJnJf6y++0AWz8H2E5Q0k6e0eN3ySEmM/+o39E//0hMRF/Sr17oMz4Tljo1l0RSNoPPluYsEBDmF35crcZyqZMVVeOG4SoM111JFS4olMIFRh5GSqJCLLlPlIkMbgMkQHEEmXCgY1TkLPi2lBvqhrctpbKwqsIDdOZvRbjzBahRQ2lumIZqtJB4HW0ku8gEM1EhiLGQK7X4gOKxkQLzzozMtRyTgwo4u1s4lForPehRfyUymaMT3Z3EovoyEysu61pwdkRXIPvfIKsSzGaDHpRm0Q8ShSFR2LK5afzotLPT4vbgVs54p5KC8HGKuslOVfFov6k8yygkh6ytANLJGWuk0eu/6Z9/Iiain9PvClRPJpjYkZQplHIwbgb6lHP4Ze86pcloCzR8vAewbdt1qgI6S770iHKM8ZHqAKHxk92wY7yjqnBrVhHHUIyl4LhQBcV3MJHYVpeRhXi2POSV6xTnxVMkw6+tvKvOZSpNlRco2eeuUguHeIvDCkGqBdaFigS7miDAgnNQ6KZbbhhKbGyiW28S+IkfZA2TaADdIOoykWW1b4BTOKDMb++UWUwHnhJ3mv2tWuQy5BzHgEzRCnaa9xUqsFu83dBZHWJ8HzmvBaaK7O3u8vq4NaL0Q+GdZfnjncCo3fT33xMT8c9nmGUSk7hneK3QcJJdtuQl8p0TT8nR3hq2lo45vZoHrq3BlFxq13T9UlJCkMhESvWcW8mySzaMKCCObwCEs0QIUuzmNKVlSKYSkQX1YFo6d2lqLn7eCFoXlnhLkdCPjWpLIVh3JicsprOI3hjCF+A5tBL7dI2b0GIGcUsnDfW//1g3O58hfQabmcZe8vCYW5Rg9UvdphXWMgSzchrkWYxxQMOTFc3NIAxSGNBcYCCaf8KG+TTXTfuSXjuk4NozFvScze/3G7bOKWu7B6CDwrLPs0QAao3+8XviQvWn9Bv7YK+EBRGBtISpaKEkv1f0dVSq4cWZU5z96SDTlrPuW4FJ1c3FNSRBtRIXrugHkeo0bLtCcT5KaDLYigDHKTvHGmcoJDIANLm5LiwxLopvjNuF9qmwMG3Xl8uyT1QMRGbZtf82LEAryszGDdtspiDc0nLAiGJuBWkLAabAjTFst2bqjW4m6csQ1OETLi7rAkaYfAuQATndMMV0zbkxaLqQfAvbz0ph4pNeGQVjVxccf0g2cfgG2XwPvx60WJtE2jL+yJv6yxCA7+Ub3zEN2Q8VWBGQHnYXEwb94w/EF332Bf3nm8TkzRGpOPqEhO6boMNBHNHxZO80PbGbaI1vlrZTN53/I8yMnCGCLyIiTEyV5GKURVI8NykmQd/N3wUr1DkLQ0HuCS51Hos4Yo1A8y6k6WZlN8CKURgOh8dcc9GBiAA1CEL9g+MIZTOIYvcCZvMFrrjbHETzipgdYxfI6S9zjS/pYOW10B02hqgNzQWxAImGC7HAaOCMWYKSO+4impLiJrRtCQS9RuRUStB2RW326UWd5b6J+pMZjPk3e4zf9UBA+nMcbqnUXZlLmrPsBf/6E/EL/eRz+g+EAIoWz1uIEz7tfA748/xqeSAp60+sZ3to+w51X5G537f2TpaoqujSkNKT+NVaDSCEgNGwnXy2zNuCC4nsMOR0pUotnLIwXtN97W6SxGuwhGNU1Z3GcM9IYsfleuRQQD2BuMosl0M/iAJVISjQnnyESFIKbjnkTvOOchp/0ibxkG+ZUkoF61QmshAMKWgkS3R5XHCJFnKWZuaDgEppIEIDG0aqWV5pOVrpx4qTdtgGPAkoAvJHMpWeKYxEDUU6sI+dHPtAZ2T3zgIv+PYr4hf6/HP6ZfpU88yPBL024ghiwXuAZoNKNY5I2D73AGd1x0fK2dIGahM3m+1HwLjB1eaXMLAE8rJ8+NPIM5eeTQTZZfBKFGs2GLR4256dmUi0PTBggi7BlRIddjLWpKYFa0VgWCZShjLAhbREjsXBJflHKWhL8Rwq3gbKfCRQlZhAc5EFsWNATPO1IC98IxyF1NPphH6Tx20jYM3ICEX9pTtqhJCuJKCxN5Quhxa4lnpqd6ATCA4uHJ+N4cR6BCQYOVGYJVz3QG0EwnLjPcdvVzz65iviz+inn9HPEhY8TEDPzAVeHAzgZ2rDbwVzt1IuHwTgx2aZ8KMvTd86xdgEcPNMxBFfKkRdQspuEA343rJAWAIaz7zEPhda/wBlN2fpt4hnhU3uxT1pioMSlLaE1pX467STYR0RCQvWUErKsGC+Vt1l9vPJFI9yGNCQCqiLLusQQ4u5EzcMfXTC3Moyy5hY05O7tM2tYKZOQkDOx6J5y2w5wC5tib3FgBw9aqUCJSkN82wYiu2P8NGOU1iYyG5P6Ep7ZDS7d/72b8Sf0y9f6AsYhVKQf0WWDUa8E3SWtelMUlJ+98HwRjGY36HsGNO5XNkZK5SFE5uAdNyqieCgFL6aw7twG+Skvwzr58xoNj89mlA2W1n+BX1xdJF0EamD5Wz4At7QnIk4zkRGW9bfKqxkNBF3kcclM6AtfSembGuZlsam1qPUIvAghdbonJrVT/5td8vwG2U3SSXtdpmzEGjgTxsJiLk5bWk/kMNucccmpx74hexwB99NWj7ejCwmvNthxnkTm07Blo/fEP+Efv6BfsoHHNlqGUS1EtO0h97AhQexhmMSb43Ssu4QvlPxqfvJ6NF+4pIIS6mhrZKh4ans6AbHNegpvh7QodTNNFQ2OwSZkhRIzXBsqyug9QrkdyluUXIYjiR7z/4rgUm0gos+IwArtD2rCOkV0bPKMe3GdGtm32K1AVk4NuMnUpDoSUKfaFoHztLzN26fdCaCVCX93PUn+iulu4h7EFBTCrY1kqVORd4yjyWKHW2ZcT4JHbaqjQ1BspN4ZXnzj98oZ3lgH+94jJ/5bc7F6cmngs5DzR1g2ebNT6QpasBcuITW29Pnf2sVgxu9ZmFCkH/FF3iT/Qh2dpQwNUPLKxOdiXtJ2FYXI3PzAS4cssPKLAjTjUQixxSK1xSpxznI62x1xgm7gujIxGB+ojDhI408JQkuckYNot6m1uvDDsU5CGlOzwji79kjl0lUxV+sxrPECz4n1UN228N5IxE/xlt+8db80pfZJws3Z2VHzmCHP/Tj18Rf0q/HmSEO+ZTTKPS90SewEpy5OPpQeIv+/UNZOdCfIQxziPzHP5VuDK08gpKdvMu5rQNRXZ58oDmrUmvcxMaurO8sMxQl1oMDFPwUAbnXCquySRSYC3mTNl6mmpoLzSGIJKwvC2KKXilcgvkELfm8yaf4Ik9T/3gEbVFPoR096XvekRXW+L3BCVrZTT8MOzB5Oah1DOOKnETTtlv/kxFaazlo+ybpaAuaZJxCLebwhg9IsZV75ewcvX5L/AX96vKloc3HmBeyQP5BZX3xe1CpvhO51pze2mjJsW6K34recN4qUmlmngEJIBJEE9UsHmDCW6C2+4pRITZx18iFRWkr4osxkbA6kHEN9RTZhX1zVFcfw3CEam5ElsLKWRhu3g1MAcJCW8LimLIVU7pHTvb0hJbZB9MozQlLgACKlz3S29Lq4ER4UsNo84KeEAqy/KcXd+m5runOtbIPI8koOmir+4OPd8azPMDQ+6AkmdOSfii+fvwBIMUrjdpH4i/o1xd9eAtZfhy2wqFTyoK8P/TN65R+KlG59PHCs4K15P+kJQ84STQBOjA3fRL1IKA8aX7hWD03KcYKNDXPR5zZUxBxTnxntZaSbUTpq8UkGFwF0MuqA1bKgJWAK0Q0kUUirIAZBJji24OL9TMRpMWFHYG6WWQQOgTt691WzkL7TMpRgjWoUnEnTEnbCSuMTtKEPNsy0Wf3Qd3GW/sy72zh5pPGE1sF2qon6Yf6m+wIizz+0PT4/o74p/S7Er3h7eNP+sC/k6oc1FxUZD3RawMUa+n390Ciug5iMVDvR8h2k06am9ZdZxR96SDcpJ3pvYh7ADtPze2MpFR/J6tGA8hCcTiCY4wSkWXBlIwvPf49K6/JYSIf2aAlCYKzSVRAstjRlz3AVCu5g49MeXpkKDG3EotXAD7GNkDf6iknIJOOe3pbc+fN8UR2lzokrQtiVm1RSaS9/fj9qPEuZHmdyHLxIxCYfqHUYObo7IOKv3K0ct58/EkAsX2fugv47dIxSWmuTGWz0BxHIQb5o0QppLyDYpQdEiUBOL2A4iBWdn+kE83hHQmiQxiPE7IEfFG28uZfDi6jwcSLlCQ+7jsEWfOvCBC0m0TIDwMlrSRtMAYEkd2I1A90ZrGENuLu1Fai+JJxUMNycih8O0okadJ5Hzp8z8c7FrPCjbxHgrn9Sf6SflfPyPIeSvLwGns8PvCLUJIf4wIkgfE85ib+RPnmPVryigX4saznjaGtChsiJzvewUvYlxaNti4wx6kaBsWUa9lCOvjT6XspnnY0lNG2urfYSgIXRt8n1NynepRUqtTPDu5OPdlPQJG2ZCBYPOnwAtpCjC80toM/FSgPEqgWsWkmaPuT4/tJKDAGnIfgiZ1ztz5Kif2S0gJ+kXzaH+Y95KXfxF/Sf9UzHfiByPIeevJJr6nvpjn4Z1s6IqxKpsZzQvthZBvGtUtm5SGr8kiFEMUqWEKxJiZ8Yx07hykBvOjNaYainUaD1lJa9Z7k5VP+Etj3oUWRlV00toP+itUnSw1KvsuxlUXkDWl2H1RpS3y2HWSUFNtNKHOwlppQPzUhPO/mBKYDQCDvRoF3ji2fBG3vfc9O/Sb+Kf2XfQiTjUIHGhLnoBTJne+DKMDztplNVaz3Qy7+XujzY6Je/Fju3WJUZ0+DCdZxI1rFeEvgQYvKy7vh64EWpReTlnSy4ciutqos6wgUAzVjp/ETkUV2yLKZfbaTUZoyDh/avpt6wixzgBL/ie3IjzJX6oe9xJX1ZDYkTah166b7wf/9l/4jcAq0mWRHajKT2r0PwftQ3EKUOBZJI/4p/deb9OFTn08f4O/1fOIXFfewT7QooeHy+lKWJYD0Ya7gBNNsSBifat5ayPxIT8phLeCBCh0HrrOma+bU6o7zIcVH51WpyVw+/S85Dw52PeMw1ODiD2q0+YONTQWp96AfUGBFhGAhyYCAUx53/3glPvYHo5jWJUWWdSFIzjLq9vH4YCeryPTa3olQ5uhPkPQe8vJ+gnOCwv+zyPI2Dflxnn+cX/bPR9SwxwTUo565z8MP4oUTESRlVgWn7jACZSNarfRY47BOavzpo5ANRDthIi8oy4IID3IJokBfxpYt61lWE7NAu6JPWwoQgv0silz8RIiO89f5Q7j1dD/p0/upr9mixvdGn+d/qIksnP+z7//9BzF1/3yBCehNJOLleynyCz48f5rO0hQGxXcbZNlMfOcPIT9+aE+Ic9Jo0zD18C2024csZyRKiTteJrv0mof3dx60F2qFz2PSg5PyYMfEvqWNl/ysv37CJ/ygCp+4z/L8G+ToNHalT+/2U42PaZFjjewQfHoTCcL3l93ziAK0hN/Sa7akieDP04BAUZSNDWX4S9BZTtzh4b//73zN/8Z7ftJrjq9/GDR29jNXUQWEt9LJ1pMuNc8gNYm4sdVlzb8wCMb06EaVXTKYoUeGdtBW4g7U9+MsJ+EjfarbMgrJZt9vgzg2UjX4kK/a7cpf6CzEyO41dEjEyRvP7xSfR37xYz2f+MKnPp9Q70d5/n8XWd75+vjhZ6arOjNyLrMixZbvsD4f3evAcQgU3DW/n8Ky5bCd/ABJdk4kTzdLxnc7AZWFKNX4fFleT5Wu5TW0Q5yy+/OX9I2f/lffLQS33UTzzEG2n+S+JNmWtItfbj9xEzmIOP0x3rJ5jehrOOVxdjtHQEPypxHOhqCSSufpg+KnlyBER//HECcgC04KFB+PjzofPskM3MSiK9vpadVQPgmV3uQj7ycsjixFqBIeIXvz034iOCt32D6mg57C75iAymFpYJTg1jPz2uJjSY+NXn0fZPEzYH1xgvtuM/ARRO6mAZn+RBn2XQdbFGvHBZ9ZOofazarjJK60nfJwBaGDzvLwYd5+UD/19fvX6OLyOoVR309PhlBrcIZ2E1yakhKy/E6X+t76EJ4/+Z+IAp/yyQ+Pi5KRqwAxwW9P5hE8GTLEEVmOvGMRXITtRPwnSr8ZJlCdPYw/KNas4RTWg0n0KA+Vsv/HKfECpP0hx3t+D9e5azykBeM2Ftzv/sPez+uCfVO+7y9obw0sb9KiNf671YO2HKe/ybNkIgv1DQrQDk0aPJ9kl++DLD/Ga77fN/ab+Av6XcnI8l6C8Ag9BT75Vw2EBflLWaEh/RneA2cPj3cSL7wAhYmzNLv5TMayhZPWu82nrMQnCcPv0XFxGXIT/MWfheVVC5RYa5RBWP30gahrV3QPIuj8/PcQkLu79uynIFzK7/dFTNl+npPuK8AsaANwRxDZWkt916VA/KzjRjrzyEe2H87jJ3w8voFu9M0A9eaHXz4VWT4drRxZdOWnWB/CDlzCOPPALx4Q6p2P34EaRUWWi8IfwP8MFB0lXl5QAFlKjsz5XiK/mandvck2BVvOsg5uG65QUt6x2YRRXVqiurzscBc4z2iPqz3m98OK2Byk5QYz1992d7/acpPQuiO7n/Xwb8RmudT81OM2YD9vCbZFl12pzaE7bm32Pla6bJCoZbwg+HDS7gNvYLE6PhKjru+fpN5GjZGFkTDU2PujnSSxpn/7+oEsvyn0gd8WL95+fEaKZ0JRFAXGjBNQzF6fVJ73/AGWn1Xs/W1uosK5w+0gTBS7Z3hIlJzkldNwRLvy7XraPNo9eWpjONVB2JE2PGxU4hzk4MLvW0j0grSOIgvghUTZZS129KL8dqYAJ16QYim0qDzYGvdg9GxRqZ07omJ/wryguN4MkLHanT7n76AwrozcE7wT4pxQ6f3U4xOA6VORqxH/hH590WfPo9B7CAXpkTA+kBeKZOfT0eH0YiZdsObgBBUAkT2r4nkrftbfDh13H05d2nBp9+FPkEGru1y2/CibOBR/XGp+Il0sSidfy0Jekp6Cb44STEVwgb+Z32AuncSQRfElIYtPRtF5mZ+9mzqDD92WgoUIBPN+cw+lUHst5mFpaAsoqLxiYrjHq6xrWf9DXe5AlvDZuydnkeW/9g8KyzrLvAFMQENsaFrRBJMybSf99O+LVu3fxJ/Tbyq9nNCEHj3d941Cmxe8A0r8R6NPvMw7+Xu3b5jAZbyzxOanUjfDAsW2pyyLxEnkzWqVVUNJC4SpRG69FsI7Sbgse4Z1hTB43ncp7fzSNX8d/3EoWlw8kIV3bQoy2xNENE2uf0+JBMhLx92/Bt23O88o8It0qGwbIdlazm8mUPouIrwuMa3F3Q8bTwJHXecLpNtnGBnHm8KHxfZZ5gtWJWX7/Kc+3lMYhI9IW2x1SOK2kazI8hP6VYW2ysOH//uhQ47GFmIjF/hiwC/kHQdlZHkeRqdsCfGiDeU3LMwqqZQzOuinOhxvXpnIyZNOIf2aipp2ZvBadllBoNmIvikKXHbkpUQbCCVbPShpyMI6ELFWVs7rZXoHRGY6LtGWBuTl7iDlIprork1vQT1NAnAOsK2YQnR3OBKUIrMPtQwPHvapxmm9WNaldU6tmtH5kr5qEwKfTFoMXdoxgrcl2FunJEUxilKOPf5BiPP+xx+JP6NfXvTFO9FhByVFjd6LdzMOvcVu1h+UnqTZtntFyMiPt2/CkWQRDEeTvDDzxpfRmv5TZn8RZWhn8fLOrMn9L9vWbvbiuAIfe7/ButNTuIQm3fnK0chdgg00oeQCvbaGOcgJy1BbOCGLqMIiQl2RRdIcNE4MJ/EFj34k5mIN223pfOqzO1L6oZgWxqVwpzlpvRF0tpPRnpjM71I+8rCd5BYStUZC+pGmmBZ5wIvRKYvok4CG3kF5ji+4wyxmSCQxz/L28PWILB+/Dsiyn3HokS+cpo/zkythGaUKFz5P+x+0hY+pzpLWMqC8kgSd9I1EzFz5HGArJexAr7JIPmkIJxMTAJVydJR4ycLSLnJCy0okMhe3nEpozKwlf0utVC7AFzCGHFaUtjDNX+ftoUlZBmcZf3eYiVpiLp3uNp1m+yg6fHSYjNJNVRigcg/uFlbWySVtP57mHYr86DEivMkBz/eZ5GVJ03SR7Uf0nn1LCTsELaG3gEPuWddC8fX06ZRn+/rZEdcdzk5puhV9Pv6T+AP94qIvk9O8JSkPpGP3fFnD9ZRzK29CT4YPnmJtYCt0ZiujN7fQRVRptjCGKYy5gGcsDFbRaruMF9ABNbZq7vYydJBayv4cGm9FnCTKJMlW6UnyfcL4o5jCcRpiABdmAJdBWOavooRFxq89g0uCFVNbWvP/nqMnfcs89NFTCmYhEVO73WVbuuygJ+ZctuGXbrbOmp1LW0sSheGt60zpkhn13oQ7odQikSOceMGbL95gwQIi/XXWn6dlgifK8wOQyCnVuDd00Zcf6BdvjiRndbbw4geVqL+uH/gH+sPEBBFbei9vKgoxM97yFu4UmuNbOSmjqcMpHoeX2diytZkD0Mw3wQqYXK1SsjaM4X1efGJefssRHdILXFKpVC/gKeMSrfZdFm0GnePY4Cw4DekNMwOXMQqNaQiQxfXXlvHF+YtA5kUCPdmPSJFibO4iDvzi+Eo5kA45vKwfTwJszowkJXjzggUaDD7QIVqZy4oX83P7SiLze2mxkGhLbXYaijc/QdifHl/8SUDz8R/EF33xgX5xICNswX/waJ4YDb9D9bB3Xo2eM1upC5YVit9Fx28cIFIoarpOrHaxEYom7nY5qMRbYhQPQsN7SlEYwluLJd+BD0CWLiJe8bc1zkHYmF1LODM0oKRGfEH51k4gOcFhvYIG+EKOLF3bWEiPZjhhEUAWjfmbFR3Ii4VxyW+ABLlXwl2hcD5xadju7XiE7KTIHKebhbxsTr52uARCHE6v4dpUABH95NOZgxhAECogp1euH+l7wkTiPv1TKE9f/jyJ0Tyk++zxv/86OcvPExmhd6HDg+qRlnRO8PH0UygIItnxeeA7rIPP+cVFh6MQ8E8eUFlObfBSg7Jt8N+F1ibH2bzbcvlsyLelHBqnmOg6OkGTetQ4/qi1PEehK6q2iCxFzzACuNg0BHdXu01DRA2k3A7JfRuI7k4SBRdzjtDZ7dH9Saykr5PI0tQfHN8urXOnJZW3bfluchNLKnBoMo6xLcV0esNsW3DZpM/D8jIvoGwRgUAloTgB7WmCkZoevqs/go7EFeoNrr2D2ryZx1t/4se/EBd6+Qn9mr+n6nGVo9r6TgKSMvjBuHl4BwLmQo9qy3ilAQ1Fz4iplkJcmHcAMa/Hb477TPt5K7Kul+eXPtq42Zh4ykCW6PVgAJ/SNIQpOAMOBREDF0/ZXgF9CuCRKSxciUl/LQouxRUWUiiR2VOZZqIG4IL2UIMo3d2AvGC0n8CZNtyBiO0+dLfckN9kXnreeO5LL7d5QOvxIHwyO0GGaG5FQZiFWuAsp8Gn35R0GXoHYeFIUnoCnfM7bJWdN6jNSU6OT/77T8RM9XP67eHDz3o8KAxBb0JJ2afaMH2LWFB2OZTNH4Pewh2KYi3vhZ7CdIl+VagWZvjobqCk7JIs9mTMv4qDVDzquo/qF+Jxb6RsDqcG4FhxZJeFcy+5Qv7NsnCq4AY/CAXgSkwKLgUxZTw2TDHa0sXZyjxGrBrqGva/O0mj2/BF9xXvFKuL0NAln3ze0Bnx4+1p6glEJsHKqvg2ueEQ9WnDaACHS7/Y9qAZudZJVkxBZ4ckAM2RTcArE3bIwQye36U71rRTgvtbc5YtQKbIXKqb2VKYb/5ATFQ+p9+WjVO7Sda/h5WMjzf6L5Tx6Phu5Hpw2cLHCjoUczSUTetinAV1GcKvqvGctoHTDbAcdTF6ostESQBWZhEuRns/7viumGpRjPDg73h/vrS/TlOzlE44K1UxgdaZS5RXAlVJuq8aQ2zUicdtswkuhiyDsJAruE082NKAtkgM4zb8baMbhiN/AIflO1pCPSDLDfNRh+lG4//S0z3DRHAS0ZBdzgVXtF3H1dNlO3G3Z8sZFBAWhw8+fDIZdJaMROmTP7YEwHWm/jgWoRYDN4a2KZv+8HPj1rWkTQV9wdf/TUxEP6Hflhnw/6QUyfxUP2goD1BCSwz3Ea2Cm/Pws2TvMQegofmCIvYPCI7PqcokyjE+6XAWYsEABmlW5xc3lfx7U6wuCi5D8aUBNwUaG8xXVhpSLyAsNv685Fan1Jkwf5D+yjoWMc/zICqyzGloKLg0RyHDlw5SS4NImyhVGZ/SV32md3oF86g3etVxKWwPAqb0nUbbDy51R/iYT8rdeV4vQVhZpZO+m5gMgxi5WASaIO4qRtDZAOI0HB3kGIqI8ywAS4/BvDdVkog4HaDqiRydlZ1207cDWT6jX1dYSlx5RDnyiHdSmGEGP01A2wdyZCIZoRa1JfxRZdF0CcCRqC4HwOYH+HHSyRegB9ykZvwMKOF4u3DlWojjOxu1oZJnIiAp028qhcrLYipfIQXHSmHYQrcqBrNqLoycpbrO4tMQO7JspyEBY0gxpcFMNNMrKNyC+HKrbXx3uTu3NsUOEZwvuIv0zhMIUJRJEi8t6wKo0RqjoZCgOWbw1hzNGLtogZ7R3jJ9ouUjx0BYNrPPvSDRARSoO9DQ44dcYuhWHuXbkxZDtzvT/R2RnPYd/fuPjiwfFEF8L5k+QY5dJQ+tKXgvAOXV5B1tqWg22+BGmZVMAQVeHKYn0nVE+2opzDEmlyYdCLYtLg97qUqJV5ON2oS4irnOMXhiX0oC7fj81/EHLzPYJoUu830WqqJDkJTC5g2lTpZyTXriTnMFs7mC36yCiyILwopNQwYxTaXchsEWWyYSd4g2ym6TJnybFrNyk0kupHe2M0aLNKNSa582jXvSdBheVIi9hfMWUpRRVoM50CIB+XZ8/jlaPyluexJZCNTcjUazQJL0AFj06BPhd63xX3mUZrcvSN72/TV991diInqhn1/00090dsK2Me1WAU95NuMvW1lksY0uWaIribMg1iDTGS8TeBlFmuPWEnPyg2gXrof1nPQa132XjR4HLMCL6Q2R2dvRcqqRp1AFy6ZQvSYN0Sit1MrDVK4lgAuKLMxUL6Lisi6nnC5DLsamIRBxYRqyOchoS7NfAxBY6YG0zuNJBxT1ofUZaY0no2nSOrdOd5uSioov431miqRDQLZ3aY3DMWmYiW7hMDdB6j+0ZNLO0u46SZ3WBZKKTNxEhBpxlFSH1MK78Yd2zhEt7IMga0+Pn/P07e8lLMtP7+8I1KS3vb+l7/5MTEQXffFCv3y0ePe9KouEsXGXVIt5mmVSqo12Wgw8Oa0iAeCIQOOSbfKhxvcOzhJAjdli+xzpSZRmA6dww6jksrhShFZfeSom0aIu4fUlHHKXWrKaU4qUFzaBtl5UWMrF9QLfJ7pCSZOuqDRH99pzt5eCixOWgSwdaEuPsCJjaRBUktWBDkrEYC5NwyNjQhlo0kX6IC/SOg/xpXWSMRPRYCVjPgIygi0NENtfpRnHlzXyq32USnCUkmTsiP84ub2hy/j8cxxwKDo+jDm65ROe5ZWdbWQ1Cwk+6CDBjHGsvxVsWecpevd3ffc3uv9FTESVPv9Av1wqqbdIsactIMe8IYusELAtPUheshlAsrGKnAfJ5n1Mss3Jl4Ey3exwJSyE5U+FShG+mIITDF5yirEVIQUj5DWwMahsRaeqNZ9SiuV0h/6iRGZ6xlKvMeNIHe9wUbmk2uBTQ34fwYWjMVRK9LDREqpTW5mwUk1n6RaTs2lIDznPeMuSdhMJFXNgQktr1IWHxNuMvzTXYm5oY7gbNZLeuIl0UeYCkdwwAa1xXpVpe/CM9MlYztBbPhHfT7JuUlvGdMaog4A9RAo3GQJuIv3qltFIfDfarSBugzD0CAQP7/OGBAMFLhRV4e/+TO3fYx2EPnygX32KmBIkjN1+0HbACfzl8VumGsIRSqI6i9NN+moRCNHF2WeijED50yQ+haNWEoItUT3J4ZSqm4pGTHC6wSIFXncCpukzv1SrSOGpFs+3knoxCLRSLq4VHlxkr6nVzeYUWikvIWjrmGhmUMlSi/nNYzIiNs5iOkuDBSLTO6Q71kzUoBDPDdUtfXpGTSXCW6R1vkHZvf2BNOGZjp0gMjTd6VI715iJFUUfM4b6osjYK4VDir9vNqeTl5SiNAo9KrL0RqWHCQiBpkCeJXEBXjAiAcRUVbcKzi65S+8ciMCKkjd3EQ5I9N2fqX1HYyGEf0K/e7dbfJRFeFExdr7yfmiSJQu3GEmmmGxtoKJIVCnbRp7lT3+2Dl8tzCa40uIur/VxGIQLJ1xLysLpOyhUeb22YpAOI4POzNdXC9ROo0rqBx7QUyaISHlh861qpaIAFHMrUi4uJS43Fi1tAfmmgHZLGsM1qSUhizEXoVuICETcPmei4D3r5/OOsi6mXe4O8NHZwnVzLWCAS5NX4d5my5xtJHdNzbrZPKL9a8TOFV8fptxsGnLPBKO8tRi+mrqsQuN3FxyCkGjwlnrcxD1PTBTlFerEu9wKnRBk97GnnsWa91tF9GZkRh98899EMpGFPpuRlhkbKQcy8ph2w1Dc0WBOegcvQMBuFQebaXWUQXBZYatInJ62KGMv7rNhRS+BlRzMDy1wkXTg3nNV/zj6QSrHaDrODWzwpHkJ7FdrUXmhUqS+sAdqq/KUy//Mc0oqcRpaui9L2exDh4Bc0YBcJaL5T6pJua5/i+ZZOmXjeRCZHvP109npfEOCLvVCzexcky7cNEonYQ9AXpuDDqqtPgqB1GJ5fBdNxgJhC0NTwI40KPlqonTaRWDwBeP1MjVl5ybrclB2oJfmhLJgBKE5vfvGda1x+9XNtPW+0WklMrRWcL7St3+g0eczkOXXTB+eZZF1aeicoK+7iFqSObbqb3gZHW2gQjl3u9FTEIAW1baIuk7mJVmAZZumLXl7aEb7S9wDciaC5Sz4ZHB8AqbYk/ViHHa8+gBrEC7VWaoru6tkyzpteVsCIssM4wXXmTDaX6d8ywXzLB0com4TEJPFT1K8RanKRJa0T+SbijMpN42hYRLd43GbI9KN+d0Yq7M4/xxVmnpGg0J06aOfCaXfvpFRFpdaq/lXBTcNSvMPoB9sjiSChpEMWVtRfFmzuUZGOJnTa7DlNDE9bDM+6rXWSvUm0Kzv0z7Sd/8DyHLRzy762fOAc47bbzVdT+jSE/dhS8SuPwKit5ODLO/gI5IcAEgiyhBdAlovzT9A6VRLGcMFzDhAT0zQtVR+7rX2eFvYJ8pFTQO/ypRgjPgUjdjOeeeSWpkvuVSmndrKC8+fBRkWroAyVy6gZHhyFsSUZUka7CHCvSFM9y+usw1BpJIKOaw0Dea3RkIjdy93Z1RbDmOR3I276OMRnGtyj9TsTOtKa3yPJ2+5iUU//74uRNyxyA6XknLhC1IYXz5yTCGtieosQvmVQdCVzgAWAxo4qSGg5iZQQNklA81NIjm2u8q3b4ov/oJH7faTTGtDz9d/0etXgCyVvnihXzzE7ekNIlPUMH7je2EO2pAXWloOdrILC4BRZC4TOCiSINEsP/zc+SbiAg0XWCBC1NiBCKb7de8Z0ytR7qUSwyyAKS7EVOhS8QjcSLtJnVqJzkRVM7gDbgqVF66p4/KCdcpBqUrsxNVChiGvlEFS1G+WwaEAX8B1HvNOgwWiFlMt9hnezUTBr03MpXd6bZqRtSLITreSl97k7jzcaFtuvN3KmR/+OZA0gAmK4BI3ADL0tDX5xms2N0xGU2oZqHtvAGU1oQeRGcJHWT6lrF9aYYLu8X+Cy70n73k7E1EanVoudnkYnfautv4Dfvwr3d8EZPn8hX65tYrPrMQy+HuldoWSU48BO3fYJ/QptjfRYl0DB8n0RFGmUGAxwRiyl+1EFv/kW/wEVNh1C1lDK9GQJrSQin/UofNtjD9DoAU/SL/kcDOo0wfWQx+alINQXP5theBviQtK6DdXX0HkCzJy1TK4ff4brYTFYIUcUzrsAZqUi4G30OYP91hvU1uaSGdfL9LlgLtNETc01KlLPVVegjbMQbIMO9qCL2YtdR08OuAR9K30nUmU96q7NOrEPZg747fB7mkuyiaZY45ROwjAsWgDNH2XmtkpOMckXotibX9X2V16n+/+RP07QBYi/oz+6x3yyolH5IAJQbblEHgr24om2tk9yx5QKYdtIAJ6AgzIVRXQWfwd/LuKxdV8O3H5reuvlnZBTDEEqaZi6LcQz094hTh/qVRfIlVJSoqNQgNBWCZDGXNQ4fICE9AFYb8KZXFJP1o85iGpTOhUhcUHopLyLB1c50Y549/jrQ8Reu1uSOt/58enke1CWIy6zGfaPRO0YzICE1ruzv2WW3gMUJPg3PIqtnlIHnsBqzj88UQ1Y1mWGzuAiOs1gE0ERZlaWzA3CUcQboUYilRifB8fIGAfpYNh6pSy4+c+3TtcMpJHRmP5uvcILv/+A0kLyEIf4hlW3i3y0KOR/JydtaQJbQhLDsXJ7jWWcFmTtcO07rGMTmAUwvcXmIwkQswo3LbjYXWp1OYC9Qiu4NpCowVYdCxiIgWX+XqrjFOhxNYIB1Wx5H6xaNwL+2Lh8Jur2UDiZjMeMIrtueoxw6b1agwV4kKivMZjLEFnCdotURciUpuZSLr/6lRFN4ngrIe0TmPkubuMT7II36DmNp2JbojqatmCvHZ2a6lpIsbaXhq9dukggnRwi5fyFxNZgsJiNZQdyuWmuOuet3KJ+V1dVoZiXIOj/ZwVk/GaNeOvb8UrUsAwxbv8mwVqtoY0xRgLHxJ0snjkp9FJXunff1CqAsjyK6bP3td1UGyjp+yys3Qwj3epFg+2bekJBas4kxoDBaA5noUDZuSqCs5KPW4VTczKW4IACjANcYqusBU4BRkFBd1afKe5ViqXlMr1ctoSqYp7Q2Yqz3hLYTV6fGjSXL8QXH3nMkMuqS+K4yKS/11BwQ2u0FZnGf9ek/7Xu0eRRUBqwXlhJNbupi9ottpDQ0mR7gBhBMdEltfOAnAzvvrauTXp3cjLbjiSWUApKLsYgihGhMbvBstE9rjZRSHOORduARr8txBaSTuKSGRQHGFtw2VEk1ciylFdWtapT0ATamLeMqRp5w2dVrSnMfQNffzLgiyVvrzoFw852oc5iJb+Wtql5ijG3k5MR1SaWXsPUD3hg6qCEgzFoUk00S8uvvigNL+lFD+RUYUKY2pOhsIy2phm44HQ1GWkFo/tEjQqMWT5py5beVKVF2t7GzLtNI91Jho5N6kv7LG3SUOgSAFcZ7riZlCs9Q2bhzHXTwgu8KsMpkZEVXyan+k40V99YyjaQw4x0NJ0x2Xo246udmmdRkzuHoDSWLvgVMqd3MR/a3TGBqX5GovVaQdl72o/E9jSMarbOnf212vSPywQBEzxoU/6cJq5T6ZAVsKCgAIbQxRxZ5Oja9Oo3qDJHb60co0tx0nUg5/FXQ37ypn44Pu3r+njVwuyFPrwMjP+9kl+gI+NxEv7AWfN7G/SKMZcZDNhTY02diMUXG6mgDVz5gLaUrqKx+KCJNrPhahOCsNlWD+wMaj5tyCmwPIx7i4WEnSgzR5iqS/snW91aCVzrrFLQPp47g1VCPIXaMl2iJnFMVQurmD9lLXuu3poZZ4lSqNQ9YCcp28hMmfIIjEvp4szE2Vi0h9TZ6FaIWZYZyJuFKkIWQZ3mM1DZGlT051qiw5BY2VxkJqpvLwKY8/ua6Pb/wBQ+0KE+IJ/yMnC+hLP7dzZry+6LtOkswhDNwIrHzEgKMlpXjIv9jy3jY5LwIAoutG0C+MR0Aruhy8thvcpNZNeT7sda5NvA7IQ1c+0EJfeDSXbAYeOTZErPTEtdgUpZrpgoTnXNfX4bsZH0AYaD/rCYiRqND1SGMzaClQx4fZgWEHUMD7Foxzm2tYrrvxgo8rIrVSpL8xFrpGRG/PRBVkVWA7KsFK5ol57DbBTQLm0Mi6tNUN5HTHsOlefgPBX4oEs819hCcGWlrznkZqzNlwTYswAEukNlZepsMzZp1GXOfU0xZSR+keU6RZ12WkxGuENw9GWbnTK9S5eK+W9CrAu0KN2awyIGgwySlXGp7pg2s3E3b6RUbbKCz/H5/omOEfnTAqfwix9sysgj2YTjkLS6Lvfk/QNstALiLg769froOiAMvA5ny/ews3hAJA/s5g72/Ufa8lOQszQUILfDJGWoNEICDGGOIWJlrh9qnpL5CVIueBMa3DW1ghHpjZgR4kxFq1ZAfiAAMvUVmZ1k05VGuSnKoU1yz/FWimFuHI6Mh2qWK6YvmUnLCCyoOtMiiYNaEsahbBJf4ZuSbomzcyHVqtF7k4i3HpcPtRP7+tkMWoPdc/RDXtofgnIy0jTmbh7jwSwD0ex0DtZWmlnmrd3qUO+TgoSEOAsNgRxApR2zLzkjcToNCGtYFNVFgIiMIud1prp0Yom2FGkc2rGfty//9vBJCDLRb+o9GUKraUQyiGN8uY05EGSnZfEh6IDK4jL6z+4T8iQdksZFtHJCKUWUSpEC2cRqkOFSRk27FtJUX2yCv75gqngDmYxP/Yvukl4aTdtiPDPDMuI4V4vHFjJRVzlmmaQ4QvE+av/CQ1lcrl/umqSVFt4TJBqmchSUz9LXxyipt6QibhNr4XcMuP2HT7JLYkUPhNpWdxkGQ4ut61N65duYYzD3EheNKo7c3eg7NqXrBzXJyCKerNQx/UigbGo6Ue2Kb4g6XDFZAxB3WmCDUoFgrDD3ynLtTNbU0yxWvSJ1izMnshs+3R7XkdahdsNozkEfJumbzfIUmfG/8FF3kw6b45FtBdWQnUTZfW3yI6emMuTlKCu5k4UdJHLTKlFzpylK6kRKswFLxySRm8JtpMxREuFYE15YsrIsE3T54VqAVWl6pNVygvPV8LzJt96TZypLToEWbS/VK51udN6LWvNa5JFldrCvjNFcSaCBzYNdSAsLS0QUWABDRagu2DF3BgoOKTv9RjYEEosQX+H3SJL3w4RV3+LfpAORK9WKKXDEdTWgTPtCAKQITGkO5oxuzTmno6QzAY5EGvnSiFQBrYQSnSjC0on+pqksKRBiYCnUHvKwrxJZE7YwW92uMAPGo1Qr19R+/qALOwibjkIK5suhS094dhEm8wdhk/4ijXLyFMQJjjyEcnQU6IuW9jd5YE+XvhkUNXgPbv+MSoYQ4zpuEqSBqK5CqSQMUBkEhYofLvm84OehFHoyi22U3MpMA2pf1wvL7WrHmyBEHChcjFdVBlutmrvVCIpDCIL1bjorHBDoQf3jnuJzbpaAF9SGLdrXfbdfVnxFgvRSRvZ1W62kbhDpK4QMBRTc+m1DdFXY3KjSXfMR7PMxVQY6Z1fQXMZMs1tS8yusChh6Is/DWeJJoY2aSRUYMwpB50FZyI8/ZFcIToQE7K+y4Owwm8ORH1fSUkPE9NNLKHE/7Rw9Ppnl28zshDRB/odw/ENbIekJ1aybgPtByXZGE9pDyhnamUZeTjaOoZTPbQlFAvFKaYUCYnb4DcLvEC0C2pNxMlsvReuTKC81HRF7EX7Il8MTWIp3KAqVanKBQbzxS6mzNFJJZgSoMcoDFsY98qXz1JjJmtOj4C8UInR/rLoLDUhi60jWv+TSbm+swP6qBMToeQQuXA7uEPnBuXVdx9j1KqzzFQ+6rUtlmAi07l9Z9rJS3cJZlkmGi4VszXLYHllxBoZ2q6m+KEGAfGixGgschw0jzhuDHK0hJKyux+IznuJRyLzTv8o7jGF17zSd7+nSFPiXy/0q0Kf0TEjm7eQnwVd2kOJixq8GXnW8v2g4EoYsnJiBVO29hrcDJIYw111FplzUxnluKZ30lJ5bdfFqudTVKktVD4g3LhuAvRE6gszj4jtEE0UUF6WfG1Fb4i4hmDLVHZqOL0YAiy+iMi+aRl1FiqRsETmsvSz+CiEMxGa0FYrJyQyl4aHuzyxQzTgb0qtkDS6RbpOQGPbOJrNqrAgVdEMC4i7ACh6EsC2HO/GrwmSFF/GKAQgKJ3WfUXpwo3HK7twp6qff44chABuxie8IL9IPhG+QwutcesSwCREcsSRtX6BYvy/HxaRkDqdRJb049o39PqXR2Sp9LMKUssKB9sqpmjuGDdZT3mMf0mvHT3BdpX0fO0h4D9f3Jc5yIjJ6geN/eYeDeYeEKcIpF3GK2thNm0FMcXNZt0VLFJfoETy0irsCjhyWW1tOLes8blQgIAeUKmw3KwMiAFr5goiC71QrTwLKJMZVGN9nK0dQu0T2SJiiXkWGxznOmKDUYgowIpxkxsuhwRZdLmmaspLo+k04/GQMZvcdkExOkR3J5nD0Xhytis0nYZe1SGaCDKNpBCHGVXevY3+F6t30UHCyqXSznSX3qkXkFfssbxSIZ96GFYQDRHWJYAk4vI6E21TdrhJtOAI6x7ztrCOHqylNwcl+OntG7q/ekQWppcX+vV2nHlQdgloxer+UAywrNnZRce1EanE/rccb9sl9wsoKc6DWgzFOTEBP8ico27shismU6JeS/WCBO0LMBQ3j9UP0jnI03H1ILLEXtvc6qQPGMpuR8a3VuZr8YMuKYsjTrBm7SKuXk1yWLGloaLeHSDLQWcxEzqoLaMKqU8RtNGUb3ujpvd9bt8b1uVjAW9IluNnRmGQpETB5db6qJ6MZ4SVCTpT2QXnSJRJTXnFNReIunTpMvCi2vxiQ00ckWThLw4oyBGWDjqcfda1gNyG2zxZm2Ai7EOv1KP50aJnRWY7KH38I8nHR2QZUgvlk0D7SWcVdGmJ1R7Uk2AbrTARqw+yLW3aSvKPltAKdyhhsV0h01kwNadu9Hzc5uNSClPZHVGe9wbtRkd8gPuEQFVcZMHoLby4WMDfOxDWgJywrQ5dcNp1ispU4sXF3O1kET6Ub81vru4N7aahtrjOg8KkaajDkZB2SLg0T/1PPQVSudFUlk27ZTgk0vOBtBsOpN0ziauwYpY2jFGvsBwQPCbSoYz8YKOGd3tnoQp8xJeAbioSIKNARI1SHvcmlowvFrdLT/ICJWshwziERn3fR0eHnMumT/NMZNJQ9t1/08JRlr9e6NdMH05iLRxOLqfNIKFaNjSkrD3YiDWxmSnUqVDuVUCP2YcjEHdQTPHOBIk8xVSY7u9Tmv5WRsyXixEWHH9quvvzMssNMlUJ89FMspSLx7dz0GsVVrSKZe4cYiXlNVcfbT6CWkypFy/yregSNvAUc5rL7HmiAn5zcT/Iu7U3yBLsZ8lqi2Vbbgi5Kj0RMXklrxTJ3UO3mx4qklcZi4hQZNlnAeVrX+QVlHKn/jL6okxS8UtpaBvdTbronSMcjob40mMzy/ycKy6wyigYhxv4Yqay0Rmbd0oM7Jfuwq15Samsmy3OfxiUApHR50/HAPhwQc1x5JymGz+3f0evf3oHshT64qJfbhvwSxRWETJ4MYAXp3kfXaGd0IsmDhpACWhEDSCcyHoEnQ5vLpG22K6QvbKDN2QzEY8dxUE3zPQxzvKB/UGJxpB1IECPZICYod1WrXpKThALj+/lcdNjviYoLCVmW8r0jDBoW5JeG6kKyrcEuAOV/cRXQpZ5LRDsZ7ScE5SknCuiiW05N706Zh2RevlMpx73nqdPZEuMQ6O9467QjdCjeIFfGhSmLSGXj9rM8AoP0iHXbvuH418aUhBBcaQAHGDAn1+JaJ/WxfEnR+lk6XY5aC4jFFdWKEnZ/8XSFln67haxdstf7r9T++c7kIWpXvTbdYeQd4ILHekJ3vpII09I1i7puJxnWRmNzTUc1VkJik+whPQF/m6AL0Ovxceu446ZaEgqpXhOn4dk+wL9BgXojNnMLz7F+OzzMsGigF1daroTpC1wl0otlcs1NxtnHbdWQ9lhgBKhpNSwKhlcIcWLkGSpSzqupu5+NzZ3/U850kIeyY2pOWkys/yhYAG3Ftv87eAR87usbVu/1+BjrizOLw0BZYJOl8lrjKS8atIfec3dfQPg1cnLnJJewXLuTQkLNxVWwCEu3eOwmHMZX2IgIzgBWdRFIiTRbucooQMvoRXPy/XcfUvxR5yUmuMclCCm08c/kNzvQBYiuui3hV7WqGuaSk7iLuXcfY6iHGzmtA00MjKom6RwbeFMQ9w5xvx+90K5gCmo19rLZD42VCpUKnvx9eQjVqfi+muiKjbUANagqlJrFm6zEzRytNXZSinCM9E/axwmvtjp6FFbp4aRbTl7XMVOl9mK08CRK64LaTpuWEUeKsS8xM51xmmowzJRd9CBsxt2TozsfIfvE8lEENNfXqH0v8EZAPOk1YGeVlEfQKND0A0CjUXmBnnRCcvIi7TGr4HOSJ/PjH+6oVO/zvl54EIVl04LjDnJhzZIsnxtaHVpM+m/V3CXnSOJobs150LKbrbmNJ35CC1n7beCbr/p9fe0Iyi7vyr9rNDPeL+CvB15CgXrJ402oeQtYcoCNFsRd/tkaXkywgVFFGj3vrJkTEmyC83DglSplIL7ykGptQyLFutj8s0Whdh1WdwhnBNQOJk6T5d5adMVjgfBfQ/VXOAmrDUk4MmR+XwcglDE9TBL9V0hhtaaiCz231l0iHoUWbyZhTbabdeEC5Rv+133O3Rxa+2TT0mKI8IdIAP2oR1ocKuoQRuDirvJLTIdV8lL4Cw6HOGAw22yj4E1498nalOmRSeoYCQfxyUgOKFgISq4hAfPIuhIKmcwbWUZlGhrTsdrAancn9aybhiU2r+offVuZGH6cNGvVhtoy18iSUmp/CobD6hIjP8j+6DMjDhV2BJcKUsuT9xjNtqCYOEeEMZtJVrR8z/WVoIwF4d5UhXjLAXYB95UNpm2AgeJvdkpy5/+1vgcsTIgpTDiG8ywmsj+2G5Chy2h2b97LaH+ZAkpsgjPEyJLnqVToCeNIX2LeVxzoOdSol7MUJs5BHMbOi/TJ7IrIi30cjvKtM53rumebKX5ujMcSFP4sAMjvj00Lhk5l5kMZWDTa5vRuNc2KyC0Cgqwgy102+eKUIEZp6wL0Ou4tGb/4zNIarJttO4WLdcCZDGt6WD0kGSoWqO69vz9pxDqfwNZiMoL/fYw8jzRE2zhjwARbJ2lXhvzbLbvU5cmhCDuWostxSUgOUgtQizBZi49xOT0z4Cqpt8HYroui5bUsMpsTlBq2IcErWX8cSwqVFbXuXo/S7EC3TH4MPFLLIsroK0U4SHcsi5kj7jtFU6UgKQyTke7N0R6Rlbvw4PxHDK4ma2Qht/Jy+WEVJfVyFyTkJprugONF93hOofuDakDbcaQHUJrXS8QgRt9+zm0/GRcfbZ70jMp535TA2oDJvSr9TlQF7pJ+2fCsDPCuPY/UgVVJYRcmkoqMD2lHF0ABcOXuFhEy41XThvPAE9bSkK35+j2QLOuKcV3/vh7IvkEZKFKvyz0RQqbcFgm3Kgwsui7WMgiO69nFWsXp7kw1ZZ3gtBF9omGQYgFjWY6RMsolJK4PD/Nc79Qp4LBRqhQKUd5pZrE66G4yW5SUKUkSSWyleIONJwNGktGfo4er3wQ+M1Uw70RPBvAS6rF/kFzWf/lbU+M/7c4spgr1OKxxJZoS8IU2E684YJihwtheGpjVBzcdo9dByJfKWrSKcgoPfnN8UuvoPX6puKOswydpTvuzAeveq66B9VIA7h7kyiGXAiCLQWDcwM+gHqk+0TYVrcOPnTwkrZUJWkrhBUKK77sUrzz9Oq3dP+ZDnMPnb7wk4v+g/YXPIKbwzu9Fryhze6y5CA/khQckYJnjL4yH4hJbOcv2JZAoal/wZRl/NGlIK2BLS+zInflLC+MJfs2EFXsWIFClgwrVqrCvqxY8CrjyyQjKLVs/aAJjHpxNVrLQXbJ4IIlcmkI8uanHvtZ1jqF7d4zrg4tVrQm4iytO22gKeX6BDSegVtFtpQ4Rqe2MJe8owin0Rx07gle4wWv3kqXMWXMQfesqWx6hgBD/yiswHBkqgpH6KH4SlGlplAsprwjwYkhF8eX3YiUt40WjWaFEjp41el7x4P7L9S//URkISoX/e5BVTmRF/SPU5Cfo61DMcYWNZd10Tm5yBMaHkYh9HcSpgTX2UKpOP4Q03XFmWgCTUHVFs6hYhSljktjsQNBw2yjklJvg8STqZiaY991NidIH6g35NE4c4XU6EmCC/jNwhcTSi0lLjpHfIEnN51PAC4d3R+gLYHCODHRPlqDmK4ri6KdLKIHmNUJmu4PWELjldJtWsl/x2Cu20bwegjFDc4CyV2lNtI639Q63UTU4Eo9WGF6HRHFF2yBKqjRRujZdFxixA7QBHcXy4IFFHNxKcNC/ej78KMrdFJkXv9A1D8ZWajSfzB9/iiypLXm7XJQ2P05PUm7roO0rMwHyVaIKfCdEV8qdEzcFr+jw+v4U6Cl2uYjnp9+KlSLmzthFJLywmY8h9OF4/zYqI974aSwcInMpYxO3FD4hI1N9VpKEkDExbsCWsqvEJNL5ITKlHV9DgLvmWoqUkiFcm2XxO3bJK5TlTkKEWDKBAvlLHpccVIVC+NKk1tPNd8KN0BhAppY/wvMRNOHRss5eUP2W1wpmh2Xk6d44r8NA4ioQ123BPEFimw5SSpbwqKohPZQyryQ5DVFXkpYbNSS3dU02hnPx3jLLoY7B6J/0/0nOg89D6SFPi/0H3zQXHmDF9nr4XjsneJJoDQNSR589mHcHjtW0mtSBE4gUJdcZ5sc7ApZuEjq91PLDA/iTFQpjEIFlN2L7IyhO0esOssHDn7zFaoPvO92IMUVev9LIaqjjnu+ISt5CZVxF8w+Yd1JuHIIyMHpjyHTcoQSW0rcIUtL+CKZtkjQIaiJNDCGusSL65KvAuE+NO4rag2d6iwyHaIEK022gotIZ4vJ3T0cM7LBZ4DXxz7vgcz2KQjoqAbtQCNQvG214u4KkW4q4upziYa0/4/6SvyOkC4nGpI669T5DtH+xUvK2LF7PXpGoTnhr9S/+V7IMgaiA6akouz0GqY9pqRByUXfNObIIuLKJtcfrnxIiO2H36peYzkNlVEIKvkHfBSVLitQFesdqCa+lGnfWI72xU2iHLotijUfYsEtXjIMFQpaVfcCR5qdldjxIDjVDG4Rz6L/8ccf20nIVgBfYnyO4KLjZh2xEnFnmH0MYjr16D03ieW48T7hqHc0TBGB4gJTbYXE0iu+TOSjUIOci8hOWJH8TByI1I2+Y0J3bgOo3zwjefQ6xSLSChdpE1Tn5TU/IgJ2GQxHGFEBlhFq/WP+RaIDTboutPWkcWuRlmh/ojBOZNB73oXuVgnG9wAeR6E3kWUORNtsPi97PUklSe38cq5xSggSqVASaMNlD0OZSGRwpIrii11vH7/F8adWV1XC1QwYhezcxgAXVG1dxx1RFziQauZO2eVZrKf2JR8nsi8N8SU02mLH7ZzbZmrOBqLU1xvTcVPNpRpq5WwaCjqLkRdO2u3sl9ON5zvCSp/eM0tgLoAv2lGgBMAl3qZOc9P5qGM2t8/ylNeGRpIZydvWBfeSWwIXHXxa97Bc12zu3W0OMj/Il4dunVCUvAyga3F3SlXbEGOBAadKgI+0gpgSLvkFEYPSZoAkCtMPwq3dTtx1suwHpcdR6G1kYfpJBYfoAVNkSa/QkuU/SbaQys+sRDY2UEk9T5RV2yTo6ldLzePPdJpt08YOZDDxRRVIDRdimvE4osFomFljtVI+cGG1nBncZd0w2rMVK4LDeMsEDsjCpejKRUxqD1lqbsw7lx8VOBpDlo6LzU9U/eLqyPvjaecFWcx1NpRp8fDQTeFqYpNZerJdUJQur+YcdbCfgw+tMfzZ4TLpRjwwouUsxHtwGQMUOES908cxJbWwPK0g1Rv1FjDFOMuti1DTLWoH8bpTD3uJoh5QTuie8SWNP4g4qUuBdrpMkmN5lWBiqd32yQ7feP+F5NsfgCxE5aLfrmeVKaZpt7k4WYItsUQy2UCIMiyQRklJ3LX6gHNyv0TEoVlqxGn8wSZYEGip0FXDTDT+vnwUsnzrVEOgOcFhxVyhFy4EVpH3ISj0OLUBoKnoBOnp6Fn7NEUW1hvPRHPqsYHIZp+RlxtYKjxjMtBKKVw4rQtxBJewuZld57ZWtFBI9GueRbwzQab7g/zlthZI8iuFLaDMjMmJ32nlMPI4bRnT04yuYCcLtkbdcQXp1TIvXuMiXcYc1AY9EYePRlFkaUBemiZ+uh9lguHIOYgiCG8bXgA+ZHtvpGX6I5B2oUWg3RhGLXdBpSUA2bEbEeKxKyQ/CFmo0C+YvjxbzttVoBVlshVNuwLtkWGLExNL7EmA2SdUsex4DdiqpLfIzBUyBXc+71WUPjeZfDtnDx2majGfKETgCpUPDhmlxtTcunw4dRCgM3g1VVMwDDm6kZTjolAyeAqr7HIRs56vr0HKnXHbS4Nz6boQCi4l2kP2vx+j2Txpi2krEVbaUqcA3rNLuaNRySajTnzDlR/bDLLbhl1dIX0elFrxw4k6K8G5IlssCmORY00LhpGeSVOZVsgu2XfSDLA+6ESvnUiC8uIpwnUZk+gGjXbRYqh7Q13orIxJOTqsRFOqyF1OHdG6Z9TyOlJ4sNZHfUvtz/TWuENvvuJDmTtE+2lo7eVfM7WxG2E7DQVWwttxJvg+M62/y7NgtrSEcC1XH38wIMfzaoZHO2qJ+oslcVk/90TXy/i8hj1mBnrykicjBJQAKzN0ixeFJvqRSjk2lk1tRcUUl3Lh2qFNRrgilAtZohm0PrYmP144C1jOrrlAncLYBb47XGtd6xSE7vjYDCO/8mP67jIT2Y0R33WeX1J3mWzqGZYQZO06fVTTOtnPDjpuLU8EscpKJS9d6JWIOhxx7Zr9lzfIS9JQNIDLmFXpQfrF8G7Ov6DHtExDefbZZl6Mj6y5uJ5bF9rSTfl9kIWICpwKWZFljeFqoDZDTxRo87oznf3mKK9scrc5hutURdfyjKrUy+OlBR7ksNywfAB0Br5c+l/zF3Opy9iELvFuYX0JkxGjmusLRFIq84AYlvqBmb1Ae3Q+8QtkbQuVa16P5osKCb+wabpqACmvqantSfhi95uJ6CWX9XPaFWJYGipZwYV0/8QRCLOI2cwGK12E+V66oKKRa+fcdXqyLJwVceu5xRvYyszsC2vIRXrnV4HeFgu/aBymr/2VfgZg7N6F8UfJyy0zKYcOkQ9EqrzMD7BZSHbYOvaR4/iTSlviwVaUY1Y5ls/PyGmJMS0Txc0AVFvyDHXT/Xt6ByOh97zoy0K/WO3ntbAWFZZdddO6H5S9ob4Y1T2CzrsxBT5VafzBa8zMrrwYVTFYwVmp6FdLpQueEaZaqZYQ5zcTGtgK22TE2iZ3semvxRFkAI1tJM7tZ8v4a2mLZ+TAdVZreYxI438DW0pUmkPbaD9AMWFe7joiC5T4q4qgd+NJ2ih5nAOAa7dxjSiEXMKdU5097h5uFYbCJ+3TtrBch0VESP0Dl/HnpXce2u0dwyz3VGpFCypFBynTa+1LNhDNr8It+UBSxF/clkXOFtSWtPFM0NKASgov4RTeDT4UfSWSTEOS94xxXtnFefvX1L/6kZCFqNQYbKG943PRxlou22+R3Vcl0pnUOymR3eBy0DL+wNXlfLMLC6YLhFngSnMtDkalwARkXx3DEaowzLVgk3Z5YRdcEnDAujOD8mJnD3mOS8QvFNuzGZaGfMIrceHQfSIrZLGgbVW/uSwKS9wV8ovOhjjcaZdniRUtA1ZGd6yqLR5X6TKFFcvjImfxRu54Wuw2FmOJ22EPxcmoxSv0QYXBggUJ6ZWPPiUNkVh0X9pO3VsozlFDwCoS23sexduLaguZOhyOgh6VDWZezKCSgH0pcFmZi+BxNTCe5JCpoyXIu0ow9x+I2o+GLFS0dpt2+ggdBh/OZhCjl5R2CKO9eS3DUV5KDO9QrgAxxf0MzbzFVWaEElxrZuUjbjabLsM6H7EPRy/qzV6VqHBMyoV7zGx1cBjkh5uHNYb95+vxfvPEppyOu/zyIbP7YG4SAXOh8XxhvpZ1obpMQ2ndmbe7iP2w9JxhhaZDdAOsJAfazj+ns0RNd5o7HBK78fJ8kHL3eTlPygVZN3R0N+ldR5imENDVdQZMaQofc2hC8jLIDgWgQRWmxT7POBwlBEnyLSexdjcKreWVei936XnRqWdtk9rgy3jwNbW/0vsGHXrn6z4r9J+0BG3pDcm2LO38JZ314IW2oGoruaO/PI4/yFxwfTmpLcXHH38caYvDiiZcqgq3xhmu6jMRT8NotkQhrFQVa5MxZITlxflQOp9aXoiDo6xmkGGK9t4FzuK336VczHYN3mYfdqChko+BMNxiiS0KPbYMmVW0WRqav2pSjjzMMocgZy7U9HZiJ3qVeUQRaMvEphuqFZCnwKCkpMNmHwm1/joKhYoWX1AUuXXYuVVSuVWRVQSRW5lZg2OQsIqQbs/ewGjCY/LZyh3rDXkZEJDUlmw/P3rPCXFkITXJJJKtIT1coa+of/2jIgsRFfoN04cY0t8n92mJt/Fx8LH2uZKcIMnzUZqGSsCUBCuetY2mD3HIyF01YE1BLoMXzIoSGRVoWNFkYpDiTmGqdd5C1S1Ea07gACsjqzK12ym+VHeg41my0ERZdKIJK4jYyH8tcX74H4Ytxe+hfiHVX8JAVE95lhYPsLaYxO0Uz7AS6LUQ9u86+9w4GfWovEAvVFcpN1wgsp3G+YIBKBNcpjEkkF6R4AQ5uAh91D/4HZSUCTdam3B3IoWPEGm5AzFJhMWaFpIK0wxI3xiOqG+YSJF9dQvFk4zJAGI5Ws58mIDmi1+p/YHezUU+AVl+wfRlcpH53TyF81DjqTbOTtDmlWEaYuwOib8NSi1IKhS3DQ16GExojlSlLMKtW9ELrFSYkkrhi4PfPH7yC6wmXkyWza3uPbPNTRx13GESlbz3rKa5esw83aLgNBeIFtfwP1iItMQYiwGNDa/MeA8ExyIbhTzvv7RA6ecmbiHqBaIZkMNxqfuGtAdYbEcx8pTx+lewhdVj9teYgttAwTV36XaG4uNPmxDQW1BbbHQLmWF1gpy8RJISLGcJ9nOXqOxGfNmVLVDaZgz/h2wAhZe0C8k+UyfnzEv/O8k//xeQhagUzePyklLZDUQbMSW6RUh89h0rGzDidNB8GX+ScGsR/o1JNFxkCNfmjBwItxqNc0236msirIzn+aWEhqeLnJtczDWGbmOdArPOQR+Yyc+DTKlFW1cwcTuJjGm04ARxAUAx77kS8XzlEF9IN4nWKrnxLcQds+KSwWWz8UzQXyL5pHzqVTDQma0r5tOK10H5cNT9MCtSGFdnQW2BCch6XqA7au4xj+8bU890kfGBoUyH2QfVFvKhKWEHEhY/Eg1b0T4NycY56iGYK6u+C4elHR12Yw4/rhHt4/9AdtofR2vEj48sxPRzpp8ufXHl0Gi7GX/s9DIdc3FBUqE3xx+43UHoeWwnIxQkLFBLi8JCNuBgNK4s+EJ04aaiw8qIvbBdTfVEHCgsV0jE+YoQJHEVBoPUMk1zez1BKO5aMiyVc19/8bPwhjib+/B7nUVQ5ZPwODlEuj8zdw7DzZBuT5ptZD6R0pZOsAw9wSg5RLiO2ASzLbG0JagtYbl5SLZ3tIFuz8X534O5wAKRw4TMlhbPyzXVYiAjJ7tNaFdkoJNv6xz1xQlKZATKLiUFW5aCKO6P8Vwcggxf/kn9b5+EFZ/2l+m4OYeybXKKDQlHJ4iWbeZ1uTkbpAzuD44/WJRmVIXTy3AhyEoVGGL+RRNxKtOiHzTLFohe9A0vgxUmYnrxDQBmGuUJfIWAP6uFZESGR1juZYblwh1V86Tntxju2Oxjm0RqFSG6RqtoYwlNoBEaFIZJtD3XZfqALGZRivgh8r4QFquw9ISLhXFpdztxnCLsfjNEKYlPQwY6M5s7gvz2WEDBFd8bwu3nW3rvBVtX1A8ycCF8figjzVWYiRq3QkbcJHJwQcJiuNoBljv8L9eAvEgkL3k4SoNPwI479qCf2nOXDEsahVZe0/+H5PV/EVmI6T+ZPo/ia5UjyuQNoGcvefuaQEw4TUPYipCKV1DEBd1k7XYKtAUzcspE7KtskAQO9FUji6nmExEzvVRmnnn8qnbyBzbBxXcOLbbvki3MQSUeV1XpRCEJzqpeS5M23lRVz8gjc1CpvaEtJWVwjbO0tblSwqAUtNvlMGtYdI7B/6m2dHs+VPxr2H8Cx1Rn44kitYQGPZkjD0q2TaQJvWoTgihkmJLS4wPtTGgSwQW4CVZAoY2+Jy/YYINbRajsSoSGTmcmkoajtdslCTGGNX1X9z9vGMGL+3ckf/xUoPjkvz4U+tUnqbaAF5v07VlSKTFbfjaVrWHfAqQMHU5r9Da9Zh4NxJJKlF1YZw+2Bn+3ijCMO4cgVh+a6dLxyi6TsZQP7NfICsRzF8GFMd0P09AUbhmGIFsaMnmFJ6OhEgQXikUtpFwmAUpuq9xNQ+G/qtLGfysBXCadibCCU486RFr1JD7X2MQUuuYUVoJDZCm7HjpcOsxBrwZDFl1RvHh1j7krQ3G9Fh9orn/EbUnf3rL8Ic/S4TZkc0BJilODo0zbxaL5DrQdjk74IqemhR2j2a4REdxgnWbzn0i++19HFmL6HS9y7O7XwkuT09Yeophhyf9qr5KKd2JHSWVVVbCTpaLSEIkJQRCOQE8psDqEIOLGEGi6zmIKCdMHFXSvyWVmPqUAfFx6RQgmozANWeLWGhIuxs1Dv3yIki1eXL2ArcDRD5dsbWLi5ZAzRP6pUq6qnEHb1SFq+bCZLxClI4pgFYlor4LLLh1YTLfSOdNcZpIFKUzTCQhrLu+k4/q80/tkIgM7JLpCBi6jVdvtIaiqvCGea11QGJyzcclvGXRgJbIJ5uKgdK/QI5l6xGmI4mHGedp1nZgQSs69UNSJPlL/n++BEt/nr58w/WcqguPHrULeqCdvSSqUwqFrUKV6VmWlJ5tG/ogppGSEZg5lKYIq2WbOJAXYiq0vXkxU6AUEXdYR6SoAKGAtk0u8E1bs1w+MGkoxC1k9aceUF3CjEUouOLEaEz+hUrvmOYiJ6IJ0/0WUc/04AaWYv/lE3lmZuxRgLCLP2g5l1+agpvdYAVYUPhRQUNDVQrmQbTGq0mQsE8pNjcBjvqekIqCk9JRnsfVCcXe5p8i/VSgQ1OYZiEAjN64pIrhkb2hnS+/wJQdzsUIBmnfTa0R2u0VRuKVG9A/q//h/hCzE9BuiD7tuyrwBtMoxD7JLvnATqMoy/nDdpNP5DCvYROm9CmnwufxjV4G/8IomW7YyuE9xH3rG55y88EtRWFEB5YoTENhDWChHcF3IE3EEZU4VL6taD4uQbSdaS8Qi2Qb7fqGMD8iSTKKlxF+6NB7DjraujDCupnKx/ImEXsEnmieHJtCMlR+Hkju2zyXvuQXZZaw+9xFya55YmXNQo97o7sQ95ln6sprYAmGx13jjHEGwZfxP0nwy8h3onutrAr4Q+ESKU0nZXfFlmXTW0pbNGvSuiiH8+r0Iy/dHFpr2c1k7aw+sJIdW6JPGH1ri+bylKvaypRvhNBl5kN/wiPdfvUrofEpsxQoWKs/n3SHiIeXOQYnLbNW3mUiXFfM0dIUN5lKBsFTeBOEMU2xd6Mr+OwNyErrO9r8oEb9oOUuNG8/7Lee2LD2nw2YNimHxGYH0Ldw8S3CjJ0GWZaIbgi3d2lh8MopAI9Kp3wofhi+mrdxTmaEW8SJKLe5Gx9IWs4198On5yFJP1dyi7Mb6FmgXnEOVl3b4IhvgeMsq4qWKgWPJk7vOX5F8/f8UWZjpN0Qv6CU/Tzq8H3/0SkXOwsUXBFP5CvlQRvioeTmI42tClRyHs801mkT+1XewlRFsMePZ2Yr+dki5lX1iYp5z0Gc8eMfUcXkqI8UStzTLFhjgxiHmYl612wrDjq0gDm7y4vo1QSqXTMe1/0NSOctAFgn/5u7CcgMsOs+o/nxACh8UqnBvKJrDOsvMTUIplMjI7wN8zE5aK17pIgo6dyehfivLuKkTyesEi5HFE83CCZpBkbl4JBeGoL4wF5uGkIwEeQUYzS1evBCIDAUi09N5FYpfWvdD45piPMa6Xyw66Sw3yR/eaKX80ZGFiD5n+g/aWTz7SWf7yky7l4htcilS8Rmm+BF9Sky+bKchWxrCdFwJfU4KInbdmfdsBZaGiHX2YdVuX2oAnZeq5jQzlDzlyrhEVay/ckxSBDylxs6ESoQj0uU34d0bYoj2X/HG0HrAbIMsDcK4eRQCwhKOPRuXEeoiQnzLGmlJ+KIsxuRbPDgPUq5NQ+YT6RKAdJIx6TTVULq21Q4dV5zCSPNiyoeY/1x4iqk55zUwAQWfCEzo5QhtHI7i+ON7if2RvLwxHIX/0045OgAmaSRfEX39fanHD0AWZvrtWqFwcn+yvsv16bclPbMu50KDSKAqceew1pCgS5EWhBLnOPNcmXMTlF0qh41EG4J4qLaskDRydKq50JiDBnlR6BlzUyGTbC0vZzMRsR42Q8ICOf1Shi2tEKMtcxwZnjlBZgPhWnOQb0s4OTRFXEUWni4P/sfOeypVtbW9RMkBf/12mBPuOarwUjQ3u1T0NWg/69phlHLjY9JwrbT5UbflING0fuuane0wDYkH4ZC5SMvP5BVn1F9w7xnKn8KucwKgRbvNDCWdtzXWQzFWdx6ORs9Twhewk8KI9AMIyw9EFiL6nJS2nN2ftzDlKLKUfHN481WOrXHwKSkp4B/9IIY+pzA6FQjFLfwF1dzC8BrFl4Ea9ny13yrTMUGXiT5UEqYPQ3mBRH+FC/C2dkhzI5HdOYI4/wUZ/7U+7gpQMuVbFnrhTVVlnWMUparti/aWszZ8iHaoqlIrmPEf9QgxKSeUAnIemUtPvuKps7UXCq8pKlUZ0NDmR11UtRVdDjJw6eLT0PxtWh1SsHBLyPyjviwTESwcEYi7Epqfus6CyGiQsFg0DvsWnHpIlLk65dlnPxzJurW4vR8yXvx3on/+AN5BP/SvaRIdcGT3W37wg5bFZSTrXHPrGVIVkzTFsKACxKTTH1FGKRDhpwgrDNoKI6wY0JjIwvOVM+w/9VoVcWE4okIXz+fh12LSiTrQc/B5yZORwcf0nlGpxVQLoisTf9B1Id0bClsT1qWgO2FsVZW8IIsX38qu/+mmfDUxdLLQDlCCIe15lg5d3B1KFZpwD+TFbN6BIxNZLFxr/EXho9mToqkWPXi4gousqm2chma7AkERN4W6ObzQGlhJ2ntuufEmCDEx/NxwdKKn4WirpzyoLR9J/ucH4cIPR5afEv18z01O4MJb5hKvF2YDyD780HSG/6nFVEu1tX/add+W0Hfr+MIBX57YCkw9xlYIcWQnr1wgwQzQmUhEYBsx6xr01JpN0P2gkw7BilByoDm6Rax+s/1zz/8xpljLi80c7iJWh5gHZNHVIaFoBjmyTAqDF4juTWQuGEN4ZH6IL0ZbRvpW0HV2Ebf3WX9NBi4GH12tZdNr24zV+nCksq5TmO7CimsuEiyhLLUQXA4RD7C4NxT7cXN7SzSDwpfiDlHf1i/Q83BE/XBRJFnRfyX65v9nZCGiXxH95IwpyTbagQhBpja8AKMru8RtqEcocaWX/adg5g1L5FDQrTU+CEeFAtAMPmJOs4u47C+49DUVQYd1maiYAz2frEperkKFQa9VbeXC2+/eUDnlmOINMx6cs3ScekYe7bftoRc28oIkxTY3p/tHwi988Dm7tT3h7aFOnUML1LRvdt7zKxiznbSvX1O5HUekjuuLcQiakTbRqWf+ak/2SFiIxpWyOSWpOnsLMSosChwiYcXZmYvssrkxwNIARFqPfhCYzdLDjiLmbrftUPv16EQfl+FoizKAL9KI/k30px8KCj8KsnxGcQH6TFhsugFiIuFfdj/MhzUrFKkKriznSu2DyJLScbTVbrcB/0XETXhhtGVQEoYMC/IUYnrRX6fxbOGXMSIJfbhmYJeIXoql+EeRAl/stAWHIIzbqmdENfjQiimq42L6VkPULt9ysIS4EJEQIAukb3GNKP0bnfsr0WMmEdsVIveAEpS4PTQJy1xlHluIJPQ6HGjqoz4kEZammJKmIeQvGrcdHdvU4wJRj9OQxEYFCRNTS0JMDLCkKrltUm5DXvp+9rGVokBe5FFqEer05nA0H/yJ6Lv/E8iCtAUb39+K7fPD+JOWcxd7CNvhrGFb++l9g7lsw7gcJqMSXZ5EW1a1ZZKUEppZJiKMrC37u5Uo4pr4Ml7zUqbmMmmLMpcyMy/z1GE6+pHGH1x3hlFof11oFq+Ei/Hew6ISTKIwW2QBg3nquHCJVaFnCr1YhYvHEof3nGafKaBItqVTm7+ImcoDPoyYiG4DkaZXREI0zn5rKkzvEGbpcfZpUb7th6RcDLNITMqFpWeKALR0WUpkK532xhCqvDn/DOCyS9NhziXjy0ei//kREOHHQpaL6DdnwrLzmLkcTOWlN5vimJPC+/gYWYynWuK6UBB0a0iyvMlWcCz6/9q71i43jht7UU1yJFlr2Y6T///zNrEVW35I82AX9kNXoS6AakrZWNKMRB6fOWSzZ5zIw6v7AorjZxBwcKXF/NqlC6UGOoWKc9vLQVXasZQqOBYU4FhEIEszdDth8csT+CzE0kIf+6fFzEdv3y5+FrFZTIoj9eWElltMkCX8bXgmoKkq4yVbthN8gW5HDepY3M9WS2/N9d0rjbxgoyprS47XtVEVJG9l8Jd1XHH8ZYOh6q0Wb9ZqdlimTTmzWniLgikgb7W062MQwgOKOjNlj54MATUruWTf9zJbqcD//geL4z4BsgD4HniGWNvPFVtzVRLuyA6slGUueeKyOC6xy3B8x/OODhPasqAUKNOWxFbcAJH4Si7bLtKJjMFNQZGGF0Ios0gfViRDd3yVBl5H2V62OaCwdaX4Ggu92/4gSYBycrTZXwLFUbg4h97NHeOIVqhLe1hs0n5/if/q17WQAuqCiLLnIIjYglnHCa1bZqwr4UV6Yk7tQBO7B3P+sm5nM3fX1oHLSmpo2vFHZz2KFW3HgrNa/JlEsdVC3m3c7ZnmiRpUBYNWXWlR85Et+kGw8hvw5q+Bg78QWRbgR+DwnqKKy57JVckDQWHIEIv7Wxiyy1yKX5pWgnfrDyEysECiLSIEK2KncgxYGWpoA44eLR36tyzs1JqnK8NtcfYt+sBRaZ6LAifCmqNspEa0zQSIVfs5KxvDijQldOiYQocfGovB4g0ug5iAOJeCh1bhxzjt7EzFFjsm8RyiVIKSczhXXVVV7rX19KuKUZLNVdH+fCMsmxLpwkerJywKtZ0s9lJjQY5XtCj5KWtHqEFJCFy0TlbkDhypbbAwLJ1TdTZtDfs8NWENEtbsbG9xmKK7zkuQQtuVf37QKWWfGFkAvAC+26nDvU8QtYMqSlqewDso6eeUKXMJO5+W5Ncuo5jLfIRhZSG5tJTRmrMTy7a2/OKRJeyUs24L+yaAmydq0KM4HBxVGe9ac1cilznI5Bz4BWhrGfrEUCv7Q04YF/t5ZuhAg6WRF5sV0k6CnLR1v5JcXeG/QEkTjY46mbg9PHbrWloYBB22C7fmOlLo2gOgtf/TMyDza/U8kGKYuIwm6yitKGJBTg16+uyyDTpjf+LZQcbq67Y6hg956f9K/bcKqrqoX09Js0VjJybcaijHPt4rjvZz6P+iy/+xkQXAP1pQGc6qkWnpNm/hD30533aDP8PCzg9CiZtuuVMLPiWeYCWPCwVvJdAW4bFm3iknk7SIdZDIWNfSKnNCxVxCk0ZwNgAChdMdXLZvPPYfUtACo76Ofy6ICmGKHTbUjxxy9u10t7bJohmydLFjVa2zX+IfTNw2poxGVZT6G8NVQd+WoKrAw7BItg8/HrBVbM994SL6EFADGu+tVB2qR9fms2pnKK3v370SR2R6xdcKKVpjxox1kjFr3QUXDomyj5vZitvCbY3+5Ney+owhdJ05LPqRjNuPhywn2C7LyYlYSSIFwyU0WZz8Kc1pjEcdTnevUKtlymIYL3gKMc8QtdYcxgZcPmZISO8IV/tl6KYD66CeNxcqsGzGrRCRKZQTGX/pgZE5Lw1rmgtD+7Rpof+Y8STSNkzcZVgqY7L5AAGFe/au+4vv3IeG2lnk43d8iKBz7su5LVBuT6ViW87SDldcB5qMrxQDKVMVLrD0iyDCojr6uMqN/nOTKsO13YyYfiIiWA3RPNFYgmvuDHsufn0/y6JguzjUIErCiywH+atpl7nuNOim9srF8ei/lLB8DGQB8ArbgWfRVdmRSHGa2eOIO8zC3xbPAPEFORvpjZGQF0FLarUMCoM0Q7SJJoFKq9ha+mPAsXS/dlkGTKDvZ9kgJhi3ThyhuyobCaJ3N1g5OEBxECPAqTR7has/iyv+O4t88TKUzpIcB5jN1dB5VD4bsmjyDEM8dKaYOR5uvMXMDRG0j/ZkWGG4qYYgmoCmP7HdcWpDQytpItosp3W2S8Ekj3bQsQ3bG/cBzjqOBKmarJa0anvMhK+TQ84qF/wDW+E5I3isoenE6XjRIDsz8vI78OtfjAIfA1kOwI9+t0eWP+zdzvAl0JmSTsTJ04YxHire0y1O77gpIbrZnFp0EOH63EL6SKjCP3RQT6O3O10ILcPcNdpyIChZPMocSDdtHs22fuG0ARN9PXa5JIIjDG4apgByAjyFab0VtA6uLcHdjN4GUov/i2CBO+lXzmG4me0Vk0hpLrEqHrZ13G6At+HCA5AQZJM/tc8o68OoqGTaMhyWfsMop9TR3Fdqu1Qbaw7+i/X66/jYq2FKpyRYY67sdj6t9H99dRFyDQui4K+rnxgK5RdNs0W8eGG2iis4u9UbZf8L1CeALACeQ77f925nLoz42UJM97AUd5oqqLPvVitkuNnKvoQRU1iJ+/rL8FyHsyu0uoXCZpGxrbLZLqAQWly7f+Mmxww6WwAkDiyaaCLCsni2MuxeIi9HadESgJNI+HMS4Eg1FrOwjv2vBi+OvM+y9vlmb9zSfFCIh+AOv+gYVNfhkihTldUzlHWXtpjtir7XVnVm5XYXdqTO5wYiWN1JIAYT4F6/L8VpTdsVqiuq1GDTzvYquARao+0STpQMO6KGWROyfp2PF60X+rjakubf/noI+EjIAsjfgJv5ats9yzZPIbpVT2kKcUBGWHZbJj5uKM4FS8UZLpYTSZwYAk0GNVhJ8gdc6pe2qAWJtrBxa8X/RZKnCxwKoDgu7baC4emKtHtO2z2BwqBjjREZbC9tWNHnbxQP8XKW6LM0T2THx4WdbTY0kepm4kLP7TgcXQc9QRc+FioLGSXWf1u3RZNrExFg54VAZ7UhQ2vldtQwt2XMJXrFxLugRvysO7sUfJMlgkudFfxni6Bqmk4ME0MDQaqLkwNH5JfV66B5sUVRgXfAzx8HAD4WsuAE+Vuany1pznDWiMtUJddwOS1aQl+uM5QSGMri4yFxsBK3VXZt4spyfEVmo8/o9q3XQSaX2tQi6SAzbqW7uaelQUbxhi4zl+nX4/YcRGTQhwbQ3Rlt3Zl2dq5QEW605mwBqaXRjrN0ZEmWYNsHr8xubPFhVUhXNANWiJvAVMw5feXrJoJIDSFkQDQxxAl0uMes3DEKQMDB4GIZs/qz4qvXQTzZzJ4LfE1uDWoI87Qo+7icK7PdOzmlMkw/d9kaxNE/9S9p3H5KZAHwDeRV3KgyOe4jzQTZHNCeIOLvLWXCYpD23Yrv4AoV5AJbEY8dIFflQEeISM99OHU2HXQ0WdRvE5I8Li3qbi4TFlNMbMQcykQBta+dngyt1HnKEeTLdCLTyUtDInvLQGT7wz4KdpHlPDukk47G2o6rUTq6xnDEfBMo4UuQP+vEc2mspOOIkz9rz5I9mihtpTTbJSy+RfVNlurq/3aDnQxf+XTENTosI2DWjjt+kog92rEGISTTvsbCysids5JOOwtptDtFLm1aeKP/zW6nz4gsgPwdckrFljI7+H3auw1HEM+YC+h4ZvG1ulBgmfZxBfOh580xccc502Qzv2U8ZRi3G74oDodOZ4Qmoft8s7GYxaNMmREWCE6tgzsMlGO3ZtQLImMlLaL2aogJy4Ym2EpItHS0CTFcQpbuoRCgrB0sVsgK7beB4MOICYiA2BBQk0IrSaGOC/CurVVXDCnACXRXKNyOGz6L6aaz20Q5SnFnZ7gY6bA8iBtxWBNJ6bJIp8FQtlqqO9pgjESTYgrLE9zZz7WHPjr++0T+EsSR4hb4ST/iR//jIguOKH+jAFPi/g+33zmhjPNieDluCJ5na1kCrGDPW0kX7VSzATpGUnirNhEZKRBthRcr9TdAQRNlYc+TvWuERQpZsx440JnI0r9x6cInlOgCYTEuY6cnLD1CwgY9BkadxZR+57acRTDOdBkLPPrnPJ4JTGdkbR9OuYcq3dCDZCMp3K9FYCiGI9snnOiM4Yj5vhsuOM+lJzvb+lthPuIhxuKhzF8qnQeiwVUJfTnMFBB2UmffwV3D9FB1o0A1TC3CX2fU2B9czN7tT4p7PF1kAfAC5bvks5S4o99VQX3XNg8fokwmhiwqjkOJe2xFxgFDIYpue7aXMVXEYTOX5WyftvEXO9q5UHfO8uNxbAj1awfK8LkiMhTT5svqRlsIRFgQNT5ijoyBDhGWDVMUOBEw2TGW48jc7t0e+w0STl81yXN2++ANXEwibQDR3mIT14sgEBxEiOnCZ8gfAp2aK3OgeCh4t33s0JGa1TVuxwy0kibiCr+VXHxpZerdYt0HlzA95Hfixq3a1bnnNa1ZGMPTko4ByGGz4hf9a3txnwVZSBPlJGj+0hfOxa9iifvlknfrUGPqraSoaHNDsvbJ04lCTGcYuuLb/YrDwfksiy/ILTJ0kJYxFrSByBhEkoEyAUdMFo08yEwZ8dkQeh2mQLWnS9Lu5DMsD8RWDoBq685cQJYWHtfhvAxMYf7yAO1zN3Ieyc6QP9qGDIuJoLV9LCOaGACZd9vHf3SKJn1PgmJst7XGrdL6ftvJ4la0+FI/yLvlzEiRtiuok0IRXALQ+AJuMHfD9JDjJnzRVsxJIi/euL3Vj6qDPiGyYEHpY9CMGsFSgS+kuPW3VM/Hkvxa/7yk57tshVDDzoRnkjLCZkqUCg0foqB00VSEdrVIP97M+iwyVm03BLEUyQr+1pcTMnftrURVQrpsmNIMF8qJBo6Qz1JkaJ8BN93QBamhgSxKDm6fuJEuf9A/0gNczp2SsNtimbGZuNotW8IRN4jYe25qjgyXa/tPaJjiaYu5LbHeosMiUQqGIqbQN7osSX3qjHhYopkdlza2eCmUx4hoLHwsc5lon50ybmjTbQdLv64fVQd9SmQB5KaH0CVuq4x7s2fzzbmGW0o0UPh62V+hEOYPpQwDZRguMqn5M5oYPUHYmUAKqKS8eTNibUeUvVtCe4XTogAZoObLLCEaiIN4sZDVUuhrww5LkcyC4RPjN5+lG7SMLMAwVgx3dHXJ0RBElbTPOrCD1VCQQpb+wF8ZoEObKFXHZDPTlmrJEYXNmrxbbqbARoo8PamsgGhXi+p/Bi6uxjIFlPQ8ngeibnFUncZAKRV6rXinn+ITj0/2KD9AnvkmLofQEhfJl53AKCOO+Hb/lgcXq6zvQQwfXba4EWeXCiE2XEaxpfMX7Wviml/rJw/Lltowf9khLCUQlkKzRQllmhTSkUZLh5LSrZbiI6GREMETGbNgFMdiNdxhxEzUkJkmiMpoy4wUQ/IM+3adNFlAiQ/6wWMbm5CAI5Xi5y5kAq+xppyZtcxT1n4sPEsetT5LJyyKuFjbmriqYyvlYCs6L+BmnyXiSE3P4estoVOXCv6Tqu4sft6evwNe10/EJT4dskBQfiTDxec+8QyQvGQ7KyBqwchMEA3hI/PYSIJ963WQFLc320kk82Wo+WIvDV+YvyzSFlCGYMjGDg1KxiiAtHVQwm/NuMyGLwOM0H8s2n5Mi37QEceeQ3EoUG2ptmmicRJ3/2f8kvIpe57FaNdHDRcyc6Erm8miSvhiUuicMIWk0HBeaLlcNQG1rVYhEHHmC3m3SnUVrclnMQ+FBhQdyvBYc01hkOkpzA4264jgZot0PkYUfZZcpcsBc3p5D/xUUfHlIQuAA5a/+z5LOFY10ZlSdiKhfViZMBTx9/CWFkkHg8Avl5NRnOMrY0sLCaJSXIFlnEnUm3LcZNlwQXy1X8igRbd1i3dVlu7UloQySxdB1m0J7Ga7DntOaLKpraaAxA2liyGLppVBHAYRdgxG89D5i+mmDg3ocoaVDmZKx1zezUPhLZPNWDkPTNkWzSmRDj2T+cLZc41YMzRO7/JbAVfVV+OCTav0kt7lZbfMXFRnbCVIIVCPLvi7GuOeusdWuk3zr/qR6raPAVkA6SH03HCZXslWi19tm+cPI9zIiIe2ZbeBofBaXIMSodLKcujQ0GtyZu5uMKG9d8t9Oevsi0T/xQSRq/ZT2FykjQsxSQlaaWu7GMo47UMoI177HPyVzFCEKnOjkksbtlV3lJF6FrMO9hGZi5m4pmhYFtWWIjXI0Im9Yk6KhrUsHixaZ9/mg0KPrjqssT3bZsTwZhZUt6ulqSGPLJWmhJyzi7hRQbO9EoKhFDm7ucT/EF9+V7ypn/SDjk//KK8g36ShxOJWOu1iSkl75C5GRRICoNT0t9WT8BsqRw13poPGAawSiy0HDz2FMubWfGEHF7S3JeNLZyKloGhb7h9Q5mAog9apOxDWbAYKWy3cmpPstjDWUL1lTw01BOEwiDGFuv/jZTBxdVRarHTbJNJDZyiV4Ibmg7TbsRFiqi/417YAQUGLoCp5utx2q8N5HXfqpbKc0kyzIvVZ0gFmTiK9F1xmnu6kR5dKtww6vyt+rZ+aQuBzQAvKjyjHSTwUNrDkJq6LpT8cVnoAxLvmwlyiozY0GcSCKD9xDosM6GnXe8FfciBtDq7lRwwZ3lspklSSpyeDy+iwWmwSesOaQvZtkfSVMqACl0ZLSJ09VRn4QggCxpFAW6rLnivRHGW944lMpTjZlVloDihwGct9mLZwDMTVODZTgrnrJp5TNa7tlOuqR9PWFfiSS+M19WISpDMTF/GtPXwJXdsHxb8qFF8DsgBYsPzozkucYMoCDQucZLfMki3eKJTE2brTcWcpsXRrqMQ6qD3pCXRo3MIPChUCjowvm4BqhkvnO0t2VYy8hNiIFinsWS3oZu2CCXkJgqjsCCLns2g0WUYvzj9XPtGThU+HCfjeCigAspnDUZarjrw4DFKq6nYQsWqcdq5h+/dh/otBEq9Q8I1+ZXeWw6AabdoBLuqODVHEFS16Qf7sgUv2dAOOhLZL2ziMn1c8fIZP+OdCFkBuUH7wFf6w80lm44gpeJa9cecQSIvbhlu8pTI2yFHpFjQuZPvlLPSJG1sw7jn0WUfbCLV0HSSdjKD4OpwMQ/dgoXWHEkXMngutdzoa34EDlw07Nn1kcbJZtiA0EV+Tc8yFOI5JoTHfTBSGKy2NuXSXZNu3siU1m3syTFxSQ4YRRnZaTsSlW/jYCON8D17XAh1jzcw+nCaqowurITbatkMFkuJXIvC40Ci2IC6pVN6Aq2T0XjBu88s9iRQyoCSFfqq408/z+cZnfJRvUF7NBZEkFuNmiNJz2a/PCeXH8VzEsFqBXBXQ7luhKSE2XFynzl+xvXCQsWmBc2ghQRT0URHPR+ie48yFWQDRBoKNniSU2bjJxmJGaaWHQei7FAxTrCbXhir7GawDUEjdQKO9YupGVlRAHgaaxK8kjlz2THZMZTpD3fxhr/B3rYOnKI0IKSfQHa2MjFgqpH7Dk5K9Mt7SuFCOs54wxKyalm+zEVtnwDEryNXU7nfMRcd4tEmhPyt+qZ+NOeDzPhZyc6cmS27cyjJgQvo+fVwMniU5ta3b4iXPWMVClMTOV7UnNi7E9GRsbLFBITJczLgNdRX1dVuTOTyjaCOIwkFPCIzQ93hLGzgE2bfWuGVjpTkyvDCBSnGskqRjzUQNKake81OYxXT3BKCynLpIaIgjwghUV2/Rtf2EbNkOsCBIGg6uOqwxgTOsXE31FpoMstPLlCwVN6+ocUyxIh7qHPWRxr22sZWL8XMs8XELhWc1/yCI/lD8sn7GT/bnRhYIln+4PU+x27JEyzZoJQMCXFyCC1qYoJT78MGJh7xaoc8EGQS4PdvSf5oBk7iJZ5k2XCRVWjCCJOMmIq4a11SSF02MMoOeUFNuCJ/t384KaNNKGLc1m7ZXchllxDhLpa9ner62ecI2RoSOJr7tMlhJn/rJTTmYk0JeDBMZpX6KVvJxDWLsXSX+YrRF44ZKoR23qq7SYqRDw6IWyn0clwk9lw2qEHc+6eVGf+1/zOHAEN03VrwUulf8a4Xia0YWAAWHHyHHCbiUnW0sGnZrlwlziRRG0mlE4k6PX+jnNKyhU0FKcarHZUYGHzJWt5Q+IpSbLGMnrgcUM2vNW2mL6Sw/Mgggq+WwVWlkiCAhNWRvsYlbTB+hwc2oz22CkdVQ/zr6LEoZUP/kSwUA3azC6lSSqm/362jEmREznF1CCmevECUBwYStmGz6iJyaxmJAmEKlW+WhZ3VaiXdWaqjh+o3ZI0sK3RY2X0BTRcHB3QOXOtzZaOjKxIJJhyPg5/VTluIeLbIAcsDy94tuS+qwTLwVudjEFT8rREsqXcEfaWlLNmuFkAiUGfFSSxlVF0umiwwHN/AXCI1Kk8wxKRTQh0EENkZERf7CN3jhs8gACyGGAhsRMObC98BHzuan1L4Cyoq2pHfGEyqqBO3jIiHSUMxQAOenBBAJtOVsVKim+UM2X0IrlxLosa4FA48Ug/U4KcQoM+3jwlm8NbRyE7go3jejOG3KteNt8dN28OMVWdr/kGc4fB93tex1WKZJkGMu4g4JWXLBH7RuTpy9EhorxlxgWymt9mKw0otw2gcIjbCMyLmMWkopLe5xQom8W/SvpTSAcFKIx4gwvnFB3w5F8odJylBGHACJS5pVnYw6NFpJPot3cKV2NOmjicpspQcocibgYAume7RSiZIQrxk13OpAxJaqOAfX6yajJzZnyGYKuzO8e8VV/gmPwj2MFzwBEPezaHyejRg2VuY13B0HN5IX4M2KP+qj+EDj8TzkOQ7fx21yZd/K3dutPS3gur0t4vbghhkivhgFUWjiCrm8VpkTP0NE1VspbcIQM0BhwhJSIeYmxkowwxcE+SMQoyTiZpdL4i/bnzGPO4OachOfZUVVlBrZSlNDhCBb2DxMXIKVWn1TTj1/IWIygCZ7LoYpJluquzmgg6Zev2vKeQLiKnM1aR+loLr/qKlxq35hgtZJ9NOadfgwtpIcltfnT7Mh4akhC4DlO5QXM6pCaxamvRWQxpF0rpCDkg4Q4oNnN0NU/AwRR0XGa0BtF6r2iyR2E3CkDFHDgCIUBtnLpUykUKMz3RBp97B9S1OL4iMhRhl42iLwzi4hS/NZCFPMo21spdJaljrgo2rbOKf95gYfLIs6NEQnxbJnHT0UTfHznLZgbJmEdVjsZ7LJQrvmsgKCxtUKYTmLcrrMy/pTJTd3WHQHRN7DXHZc298qflsfEU/AY3ss36K8nMBK2Dg3fy4ENKabxIkjoSVyReK2pynEjGDIg85YtS3e3JWRBLGDy/03W1U3DZsZUJRqLAIXRYPtWFpVWZiSdCjhYovWtq1uobC5UHtF+xi0kRqXOndvZfCUlbxboiSDzlQ/NGRI1CMelw0xpnhBBA8Wjp74rgp/V4MYdnDhwyADjrBIwTflHNykrZRjghGT1lzusLBNY80U1R1WonHbE1fmfq94sz6qz/HjQxYAh7+h3Oz4LBdsF6FtT3wd/nREcbYuf6Pzen0eJD5XBoHFaKwsnWiEyNkwqJuyDkE6neGwOeMLyGop3ZR17Gbrs5AI2phIAyYM09d4CgOHwcoGN6aJCnaQpbY8qPEOU0nkzjqCszp/xNwZVery16GGoNS4RbdjQtzjjdvauZKRmm397ciVQJtxKxEZuJq/a+ViEg+Fjv+YLUI8t4yToxwJadqDi72duBeauMCf6+etrjwdZIHg8D3Kcy+C5D2wwg26OZRI2ziX97YENIHt3CZBNN4l7OB6LqNGcHBBc8xFqK1LCCLFlVPMW2HsMCnErTlWRocS7VuZ2bdCZTn4mpyYidMTouHgqmvHiforSgU5xhSiKtWYjsGHzT3DqaEaIqSkgKLnsnrJYwCUUyEdP9wsXouoo3EL3+JPmqjSVkreWZnt2wYcRD0yi2nrdS/7KUquDXBb8fMZiiuyfDi4/IDyLLEV2e3ywzu18FDirFyhpZb9x8b6nPj0R1wMJD7uiVvmPGERph6FPvY+e17IizF84Uy60KLc4geguSmncJOKQpNBVsyNloqQWctrE8xtkYgs1ZJm9lnqoDPqL3KZZTToeIAIriln6KP28hxtlIE4PJrIrTn0hSzqDgNR+DJunbm27MjQGiebbIa62cJtlwKmgbSOJAj6nuxZL2if9PJdxevHCCuPGVkAFBy/hzybjCMyrCivXJF5qT84LGG4eZe5hCYLv+t10KFPPy/dwd2mE82gcRJJfGvOZ0C55NL0SHFbF1weRMqoYIgpTn9EqLcizlIx5rIQDI0+rqTUmQyUhhFEXpTgxra3KHfnqAVXyawJkTNI8ghhR/VGTFWI+optT5HF36Z1ANP2ybQlT0Yl0A9XHbtafIdFZ7NCqg4mcsc/rE1gmZMXtehFY4VdmAfFPx8eJ6w8cmQBIDj+0MBF9htxkkIf+FRIiJi0ZdrifBm3wyVt8Be7E+5skKlxa6xkWLm0qd/GEZcy+nXmnoySi+zgDlwI7epwSJ6uJylbZW4zeguFzUP4SPuNKH1uyLotTg0ZTzHXliwS4XousZho5WoycXVEQiAUMIgJQwAZYmDZkOcgXK6r9NNqmACwWSGNzTf167KHBUPvuskAjcckasAOu54mnnU/b+a3bhU/P15YefzIsjGXviYqa6Jg7nK+w9ZMJCm9a8vAwevjTNeMVq4vsFh+ZAWWoZv8EzHzlfCFs2fMzNqp1TIiJAwBxfbttMPSSAfVWLgsN+gJJURCCZHtW9iQInMWsPPaJZKSHbN1XsYkkXXnfBIExg71wZAfKWL2EaBEqyu2OOjBkE5mpqDvYbF0eZzHHFCGyUtaraCh4YLYzWXaMmnN4X29fs9cHupjZitPBVk25kJpkTGRidUik8kgBqPiu7bWfyner+VWbliVYL24cepQJyNgX5ZxhNq3oA37ENevE2+ywNdYAC+FOoWRVOS3eosIRPtqGJ8WHTrcGD2BDssGlBANziI+GwLV/NVnQEpN3Br7/qrOYYEvsNgWW/GmCbwgkuoxJTRZDEH8KMDQRBYGZdqiTj0Zj7gELururEEczWq4E9qyp4/gzV3gtuL1A+rj/9A+jYfg9A9a1i+zspz4wCi5ucxcJFXmXHIkUTEF82Wig7hHxx05b+Kypxs82kkY5K9vvuzADp83L5wEkdVSAO1pNM8Bodu37R5yW0AO7sRn8WpIuZjr82b15ovSqNH4GmhLdVW68S4lSkriBXVCW1z8rK6Dq0n4DNGk4zAQDVYund0Rpp+Z4ERiktfH1SGjOFfWTE928qBbxc/3j5ytPC1k6Z5LS4u8n6IdWbDj5oax5ilzcV2YEkmKwQHy0JAMCCg+GLKoSKUdbGYSxp4UHwkxAJVglMwApS1b6UsVRHb0DnGcgC/j3A8SPvaNBV4N1Z4EET1B5xHOdqlUliO8CM5upSCpvSSHZUwJKdm3NcqlaqTGQw8vpgQ3+j1DUY2l/hFOGzr4vJnTaG7KRSvXp9FKJ8OPXXNT2iJ+C9QGK0+DrTw5ZNmYy2boyuy8RIzTmrloKzLr9Qdk4dZc8bTFY43MCIskHeRcGG67iLd7rZ/iGUroy7EyKmzBgIgP2bdj7RPbtxgt3iKOpIyGi/dcDFkK+SxKIIJAT0z4BEzpH3jhicRAXupgMUpkBExPMLZng3SNql+Uy/6unzBUREwZw4pJE2UyouTLurX+iOrJlXRpVaXOnFrVnboK3fOu4t8PT4KtPEVk2ZjLKywv5qkQUn9/WudHX+nkRJP4ocSOLErThpZMb20U+zmBp0iJDktr2cogLAf2bkt0WOB7K8HEBc0fDq/X27cNU/wSOfNrjMiA+7hJ/ojXRCMAUppvZh2EsWlBNeLOyJitiavER3jcubuq8GYKEisZmTQDB8fMJG3AQ4mgaSDaI2db4+AtlejRGsoo2a5JEzFbiYDCZm0ybtWverpd8fopwcpTRJatvvU/WF76dQoy81w46wnIwkqnxHOFQvrDPGVsnxM3AB1KcRB3CmJhy5YrdsFSoUlFB0kYCyuLeATxxRZLi0rKmHmACPTkYGFziplbQc6nzqoQ7UBjVi7c6FCjJ2TNsA5S9esUqptytpgJ6oUPCSJ41JiYLxlrPCoZOoy3dG7lVg6PE4WJrRbM/Nowmjgza3W6ogWoit/PeHPG06MAT/Rx+BaHlw5W8i6FWMyVaLs4ZAmSh+pwCJ5uas0ZcwF7LjQu1KyWQnwk4MgWbxcneWIBlyySQgjCPZeSmIul0VxjsVx5CJ8OIrywUjxzmash+NEh4iMWP6sfZWytOQx6IuoHDomeWNtFMXbouvat93dHBa7jUe3/rsFEMo5gtOOQ/Bf+yrbrZKOCOn3EHkq4vlES3TFuDWjenvHv81P8gD5ZZAGwPMfxO2BxJEX8cYihKTehLSkYMtQQ/5UD6alfO4mNUjDE1CbWVYIUkiR5QD+fCnI26FwoPLLQB96+NXvFguT272IQkaiGIrLwxBBhiq16MpIyei5k0w4K4+OhsSK3h8eBffA44rBgNFEYjp81JkHqeyvRwQWRGoIMwCVHw2fxC+W4v++iH3jRlKhKW5frNdEvD3i7PtFP51NGFgCHFzi8Sm6uuPFl1kcsmoIgEhmrnuCPBwlL5wZhobineS7eNBluLqOPr9uOtCi1WgJz4TzogmtrVCXYtww0Lv2RgSCWELkR5+CzaPdZ6oTCmHer5MIo/HRiTovYxEWqsaQU2dVt4aeHOu/gUYDa/weMk1vhxgudn6ITSArnfijcZjlboz3VRAFZwtjhlLasin/f47Y+3Y/mE0cWAHLA6QeUYzRcXLWfVyuIX60g8fjEktIiR1gkGrfijVuhgr8ITSoSKEhOi8SHPsZQ4Ju7VmajvHlARnEiiCstAVBGmYXtW5I/27tBIqFjQfut6cKhIQstWDBMqZ3gZHpiWTVjx2Arod2v0XkJ/ovqxHPJlIQpT6UrlW8m2lL9NpaIMpVCJZ334vYcXN0ZFFLFQ8XP949hl+3XjSwAygGH77GcfI3Fb4EyBxc+P8bMuOVtcgiBtHhxhLFirvQJyYWmhOBFUBFHT4YL4ynMtDhnVGWZxkPEXEDt2xLSoqB3Ou7EAgvNEO2qoY4OJVEYTbhjVouDGOIyU8s2Zs9KLKZOaEtNiqlSEhTzZhY7Gku6kxkiTLr83GEZmgi0nk7nOOJquERbzhX/um/664osjyWNPryIaBKYS+Q1LJFokggEHLI4aZPd3Jg0G+tBMmLSIGImLCLRxF38OijxDToOns2+BUEJt+OGvaKd+CRjRcQ1cSUhy2jKWVRUe8VWx0YoVV/zhxtBbFCC0YgTjTRkkj1jbFFBsG932IoyLqzuW6onOzVwHMRtcsFSyciycrOu+h1xmvbjYgI3f57x6xNLl794ZAEAHL/D4UUaWRTn5s6DoZllGwhLMG4ROAiPFCWskWnYnKq34AyouKJK8bjjtI/M7VuhYCiqIe6tcNgsED8uBPZZuP8G7+AaZ4GfgYaTP0ZPlAaOGmSoS4LAUGJYA4cX4OTYv2QECVqpepMFpHqy5MmREGoEFOe86BxTLB5yO7TV/YQ3K35/wJfzV/0X9ig3OH2PUlxmZDAB39MPjf4QQs+pjYylUOzXwhu3o9XiCQs/UVvsEkJlDzQDcUAUxru2ahuzZUTIVrQVipANcbixInD3GLJIHykaDi583swVfqrSDdToT2ol35dNXK66IJIUIFKSSu079YIolm7hTvwwHFFfhFM/NKRpDii8O8+GZvk0g4hOTZaeH50rfnnafu1XgCwAyhGnH1AOcxM3gwXCsKLso8kOYbncapGd+HmXsNgVdWCEAD3JvnWuikxsFOVuS0iXu7EiaYZoIItOSIpjJYmkAJQWJYfF3p2YuDoPhoA4K4SpAtpzdr3qYRbDfMT5vr72EgBlYt9icByLgTRV4IwEnRU/3WLVL+xT+CUiy/b/68S2Sw6JEpTAG7cOVooXOBw5+35KIC9TiFkYa6gm5+AjYBBG9RZJ+/ANw0bhSgu1co0cCVm2LgPyIbRMkUX90LM3Vpp3Cz+j6BsuRmfc11zAZSZCWMPll0hSfKEWAWsCpmCniZvAJSxq0ak7q7t0pqbV/NuTP8747R71i/wEfsGP4yscX8xmi2TWcOERRHRfhtBk9FaYuYg7jxXiQCeykjIhLEhTzryuSZJWysyFKQwbt653y/ZtRxDzcUcGNIuEtiNEAmdprRbd7bk4KCGfRXlciACl9h/oIiF2c/USSUFOnTEzdBGr/Sx/wrucVdeAMnQRnC5XN+jc7hQ6R5H82l/u8faML/bv9i/7UQ44fY9ymkPJ1LINuMPdfxDLgBdK9lF34qgQr8nYcfGK2kKWYL4gmTKGONqnBHzSbBSGxRGSz2Ill6CJam213chZ1M0Nae2zRd0iMSCIT4LDYtavz5gRgAYeYtTVYVRd/y27MFkrrf4nTxiKzht0bQgAHlACK6lQofo/yHxR3K94fY9z/YI/eV86smx/8958j8NN9FnARX4BljFJWDLEgI5VpO+S5LCYiYtko4zbyMSNTorG8UUXJHNjpT8B50dw7dvihY/4mpwBzUAcDMThbGg3dVYPHBpTISMjDkE4aeZUqCaSEtxc1kpJ2iDFQDq7Uj1/YQ7i6nOh7I/IVjTbt5h15xCf357x+g76hX/qvgZk2RyEZzh9h1L8OSEycVtCpxYBTehd+BZ/SIJKuD/lzVNBFFot0d8ls9YmD516YohJCbSJoOG2EI4olVzkA32W6l6q+hmi/ney+sEi9WRnlFm8RDIWM7hJghjdc1IuoAy9tWK0/rFnuyQcmZZukZwXbrVsF8+KX+5wu34NH7ivBllaZvQKy80OlCRNJIGY+JcI/bdp0uzHf5ZlFhgFUhPEEYa/W8rcbQkOi2qs+Q8O0gFiofMPIbG3Ekactd8fAMWtaNFoqUwcFr5ePYtJti4jiJGRIF7YfKnJnan9J1jVZcWuocs4MrFd9sFlQkxSqX/7elb89O7Ly4CuyNIfhxe4+W6GIBY/S+rmpoVyIPkzjZ8dVSkTtuIAJWENEG0X4y+5aztSHs9QQvvWRcspHgIlRIOzyKUOrrNsSRzZrFDDDnjvFtSpM8Olx0lct1OCHteLU/c8ZEnOrM38pcY4qfqfHKyWCsdl5rBiL3eqK6vizR3+PH9Vn7OvD1kALCecvsVyEwkL6GhEzoaEzg8KT8wxmZq4RjSAycqFgQXFAUfImx0YIUJPIyDdoAHirLMxkQA64MVOnqpYx5+z56yGxgooC4mC8+KrLln+xNQZfoAokZqIKb74P+mz0EAQqh8RgmNAoTW3GmMyOoNk5YbAKNOWra6y4vU9Htav7UP2VSJLy6Rf4vQ/CUECcxE/IlCGERtzouDs7sTPTtT0mtqSdNNUJYGmhLSvUGBD1wCF8+aII+TmGhNpyRH8DWFoCBiuI3EWqPdZOIdOVReFq8lZ0pzrLUEWVR2oBJ0lzQRDbnmCf6IpOY7x8z5/UUw83XA9jBf+doc/Hr7Oj9dXjCwtk36FwzPnnkyWPxmd8Y4saEoogtH7VM97pFD/qDvYQnR24xPa3Z8pTAiJAGfowlOVgCll5uBW4iwI5IWAg40Vu4E7LDFynuJLCKG96pm4J7pTkEPiOPDzRDQNhIQvK4atE7MhX2+5W/HmHvfrV/vZ+rqRZXucXuL40h9+5gkLpkkzu7nw6xcyZCRNNP8Hk7I/582ha5vBZWgfoZUrHlAsOSrFSx7ZAZTss9hXs3LJaokvmbDwS2q+TMnL5SeT7Jl9mant4gHIKaD+7soqiThIqMNpb+6HGGhzVX69/YIrcFdk+Y/+GApuvh1z0lH+ZGfXdvozcIhbr71LSUgKTZ5QLWVADOgnIDVcOFHGpL8vMnFVgv/Cfkp4KfxrEsBlD1DYZwEVdgliRqF2BiiWNLtu7p6JGxKigCy6E0vviCDenwBNeRB8vcW/9ccD/vjCK3BXZPl/OC8vcPoG5bSvg+BYjEgMm8d3sWmypIszBWTV2yW4LT1pgpXo1A0ogrdP+mBoYq/4eyY4IhQ2i/810Rm+kJWr6Xr0bnNrzuKh4LbwlLOOe1wjLpMUvjlQlTBhxPIHPg8i2KqYoI/zdPt3rYrX775m+XNFlg/Al2ffUdtl1mRx++KMxchFFhNME/9E0vDhuAd0Tycv1r4tSQ2VDCg03KwY7IY3VKLfAEyQJfosSdcIko/rsUZ9wyVmz7ho4qrPnkFzz4QLqAlHLrAVTcoIF63cHZKiinPFb3f48+H60bkiy3v/VBbcvMTxm0njFjs1XGfQIJGXMuEpChrnyRYvPO5QQW5+Ba6n67SPjLZb8fHQ8FBk0uUvZcdnwYyb+NhoNP35NuMgcN1/vsdlz+oQhEsrl+otHRpEE20JyygDysBbufD4kvkL8PYBb+5aSn19XJHlQ5Oj59t6XQ8c8Iv4kUxZyNw9CU8uaSKaJ5qQlzTfHAgLqO0yKrzWrOv/5YunJDkJKu9VQzVRGHiSEsAlm7hUkxvbtuHnhhCz5wmmBCIzUzpzzuIzY8wkDwhKDFbuV/z73dVSuSLL//dxOOH0LQ6nVMMNCbRM+ikhQmqf8GXCU+AFUQAdUMXW7FtY8d+7Klznn5gpkvq1PgBS3/GPvyMaCQu/DDm0JlJzKScCNfpDFA03H+A4C+EI9+uiiQsqtoQmi7/NLW2hkj4roPsz3tzi7mqpXJHlv3+cXuD0EsuxfZ7hg2fAZ9VJ/uRiC3x3LmBNSJRz3oxZ3hyKLcOmldGCM+0jXhmh/5A2r0i/GkJvOVbiOcuGBW5pi79HvVDSEA/B27d5bggT20U9HkUuM0WZQHMQe/ohD2J8Oa94+4Df7q4fiCuy/KWPm5c4vXQnDU3RJDIRUIy9r4m0L83m27Ia4kyawQWpEcdXAm2Z+LW0RtvuhCcvc7Zi3GTms2gu0XmnNiBOgJjBVgKdCYGRN2jmOuiDUYYL+4w4v97i7f31Q3BFlo/2J3Z6jptvJyeZIeBFmV2kFCknPsULoiG14Fpzjs4gYg0Qm/5IlgpoTX8R18TFrM+C7LMEQ9cKLB5TtthI+Un3UyY40r+31nEzPFtxyihf9L6sTTnOcSQkPrME2qKf2y9zp+QVWR7fn9vNC5y+wXKclPox69diljE7oQQHQAhXkpMiMkou20SilB3yQiwm1OEsAFKNzRd4QfQecAkMBa4sx7JoOLWU3TDTYTSpcJYtu7lTE3dAkucdgZjULKAwyYAeVtyd8eYd9PoLf0WWT/x49hKHFzgcZ5hSkmlS/D0sfOBD64t5M/ZFEA89G3woR0USvRVBojPhV0P8UKKJmil58XPPmlkM0nQiJoaLeqPXZc/ZxM3Zc6i67DVcqKTPN6wVv77Du2tF5Yosnz0/ev4KyzGmRdPn8ytI3wLv1Ozbt9j3WSauCisd32cJXX4GnZg6w484EzcZoOONW2YxdmXirVxAmRnuaNJKGWUq4ijAhLb057cP+P0Od+frL/UVWR7NYzni9AKnF2PsEFMXhi2SEtFEUvwco2i2VMS1VISTZjJZMr6MOAkzBSQ7aiggS0YTzOaeU9gcMMUVc5HCoGDiwlXgooeC1HCZIZHmpSoVbx/w7v6KKVdkeayPcsDpGU7fYDnMyUuRi2jiL84tFW/fAq72kgkLh80l85GQMSeqsttnSYaL4v2yyIGLb/07quIDI033xGCov6w6uVP3XZVzN1Pq1U25IsuTeNy8xOGE0zOPL9ltoToc4DbOuaacJL0jULjyLrLtgjg9FHyTQr8AskNVGGuiX5uxhqhKKP5HEYTUmiMLlm9zkbPnILUOxqT7RGaOKRVv3uL2aqZckeVJUpiC569wuBnrtSUV5CL0zAJp1j423zxuUNoUEwJm8dWV5LPwDBEQJRIuBEOZm8x8liyL7CXjSDZcgvMysV3yzSnlkURV1oo/bvH2/jrsc0WWL8bl/R+aEpD9nIjV0MzHjU8yxABKQTXfBo8jjDUDViT+alxKnRlNQkNXE7sxM2UWGOnelZrUUMiesdPKhcOUP+/w9g73Vyfliixf4J+34PgMz77B4Rj7L/ALEy7EzPnJAAh7S9vYgT1hOsPKyO2RkzmgxF+T6aIWEKAQjlhHzgGQprwZO4DyPreFL06YS8W7B7y9x90DybTr44osX+wffMHxBs9fYjm5Bf0DFC7yFAk4Mm3EeZ6iM3uFvzGoIfZ05yJoh8IY9RB/W8SUCySl12cleCs7bks0dIGquLvHuzvcnrsXc31ckeUrhJhn3+B4dIACeQ9PGQCEBDRZ+Gz3977cwCYPH+KNW3ygzwIHKxKkUJZFcDEzPDcJgIKpn4Kx2CWEyu/u8e4e9+erjXJFluujf5IPJ9w8x+nZOP5Z5OKTDDFZFjFGJJ9l4qrIfrU/YApiB1f9PdleCaoHPgASePmT6Mz0ChRrxds73N7j4XwNj6/Icn3sP5YFp+e4eYbl6CKkqX1rzzUtqQxIEXLoCTFJ+xPmj9Rnadpn5rPAa5+ppTL3WfzX8KRW3J/x7g53DzhfV6VckeX6+E8fxxNuXqAsOB37sWrwEdLUWMn0JF1x9GSfqnyIz7JtZtnTR+EiGy4atA9mOghjof/9GQ/3eHuPh2vEc0WW6+MvQ5kbHA44nHDzbHAZJJ8FVGaRYKPkK2hZdfyNkP0OLobeEcyt3IA7yKUV7KIJf11X3N2jrnj3gPtrq+2KLNfHx36UgsMRN89RFhwOWA4zBSSuERe8GPi+XICe9/yO6A6LmfosCUrmhkvf26aKd7e4P+N8NWKvyHJ9PAagKQuOJxxPKILlQOAyk0XZZ1GkrdoXrRazV94DLjMQsXr+ecX9Pc5nVODu7mrBXpHl+njk/20FxxNEsCx49hy1YllwOLoyC5KZ8qE+SwCOHTQxKVQr1hUA7u6xrlDF+Yz787W99qU+/g8Wk3UoXaTCRAAAAABJRU5ErkJggg==',

    initComponent: function() {
        var me = this;

        me.callParent(arguments);

        me.on('afterrender', function() {
            me.createCanvasElement();
        });
    },

    rgbToHex: function (r, g, b) {
        var me = this;

        return me.toHex(r) + me.toHex(g) + me.toHex(b);
    },

    toHex: function (N) {
        if (N == null) {
            return "00";
        }

        N = parseInt(N);

        if (N == 0 || isNaN(N)) {
            return "00";
        }

        N = Math.max(0, N);
        N = Math.min(N, 255);
        N = Math.round(N);

        return "0123456789ABCDEF".charAt((N - N % 16) / 16)
            + "0123456789ABCDEF".charAt(N % 16);
    },

    createPicker: function (canvas) {
        var me = this,
            ctx = canvas.getContext('2d'),
            img = new Image(),
            $canvas = Ext.get(canvas),
            mouseDown = false;

        img.src = me.imageSrc;

        img.onload = function () {
            ctx.drawImage(img, 0, 0);
        };

        $canvas.addListener('mousedown', function (event) {
            mouseDown = event.button === 0;
        });

        $canvas.addListener('mouseup', function () {
            mouseDown = false;
        });

        $canvas.addListener('mousemove', function (event) {
            if (mouseDown) {
                me.selectColor(event, ctx);
            }
        });

        $canvas.addListener('click', function (event) {
            me.selectColor(event, ctx);
        });
    },

    selectColor: function(event, ctx) {
        var me = this,
            bEvent = event.browserEvent,
            x = (typeof bEvent.offsetX !== 'undefined') ? bEvent.offsetX : bEvent.layerX,
            y = (typeof bEvent.offsetY !== 'undefined') ? bEvent.offsetY: bEvent.layerY,
            imageData = ctx.getImageData(x, y, 1, 1),
            data = imageData.data;

        var value = '#' + me.rgbToHex(data[0], data[1], data[2]);
        me.fireEvent('color-changed', me, value);
    },

    createCanvasElement: function () {
        var me = this,
            spec = {
                tag: 'canvas',
                id: 'color-picker-canvas-' + Ext.id(),
                width: 371,
                height: 371,
                style: 'cursor: default !important;'
            }, canvas;

        canvas = Ext.DomHelper.append(me.getEl().dom, spec);

        me.createPicker(canvas);
    }
});

//{/block}
