/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 *
 * @category   Shopware
 * @package    Premium
 * @subpackage Store
 * @version    $Id$
 * @author shopware AG
 */

//{namespace name="backend/premium/main"}

/**
 * todo@all: Documentation
 */
//{block name="backend/premium/store/subshops"}
Ext.define('Shopware.apps.Premium.store.Subshops', {

    /**
    * Extend for the standard ExtJS 4
    * @string
    */
    extend: 'Ext.data.Store',
    /**
    * Auto load the store after the component
    * is initialized
    * @boolean
    */
    autoLoad: false,
    /**
    * Amount of data loaded at once
    * @integer
    */
    pageSize: 20,
    /**
     * True to defer any filtering operation to the server
     * @boolean
     */
    remoteFilter: true,
    /**
    * Define the used model for this store
    * @string
    */
    model: 'Shopware.apps.Premium.model.Subshop',

    /**
     * A config object containing one or more event handlers to be added to this object during initialization
     * @object
     */
    listeners: {
        /**
         * Fires whenever records have been prefetched
         * used to add some default values to the combobox
         *
         * @event load
         * @param [object] store - Ext.data.Store
         * @return void
         */
        load: function(store) {
            var defaultSubShop = Ext.create('Shopware.apps.Premium.model.Subshop',{
                id: 0,
                name: '{s name="premium/subShop/comboBox_general"}Universally valid{/s}'
            });

            store.insert(0,defaultSubShop);
        }
    }
});
//{/block}
